document.addEventListener('DOMContentLoaded', () => {
    const provinceSelectorType = "province-selector";
    const citySelectorType = "city-selector";

    const provinceSelector = document.querySelector(`[data-for=${provinceSelectorType}]`);
    const citySelect = document.querySelector(`[data-for=${citySelectorType}] select`);
    const cityInput = document.querySelector(`[data-for=${citySelectorType}] input`);
    const cityContent = document.querySelector(`[data-for=${citySelectorType}] [data-type='select-box-content']`);

    if (!provinceSelector || !citySelect || !cityInput || !cityContent) return;

    function populateCities() {
        const provinceInput = provinceSelector.querySelector('input');
        if (!provinceInput.value) return;

        const provinceSelect = provinceSelector.querySelector('select');
        const selectedProvince = provinceSelect.selectedOptions[0].value;
        citySelect.innerHTML = '';
        cityInput.value = '';

        cityContent.querySelectorAll('li').forEach(item => {
            item.remove();
        });

        if (selectedProvince && Persian_Woo_iranCities(selectedProvince)) {
            const cities = Persian_Woo_iranCities(selectedProvince);
            cities.forEach(cityItem => {
                const cityName = cityItem[0];
                const option = document.createElement('option');
                option.value = cityName;
                option.textContent = cityName;
                citySelect.appendChild(option);

                const item = document.createElement('li');
                item.classList = 'text-body-s transition hover:bg-primary-light cursor-pointer';
                item.dataset.type = 'select-box-item';
                item.dataset.value = cityName;
                item.textContent = cityName;
                cityContent.appendChild(item);
            });
        }

        selectorSetup();
    }

    provinceSelector.addEventListener('input', populateCities);
    populateCities();
});