document.addEventListener('DOMContentLoaded', () => {
    const loginFormType = 'login-form';
    const sendOtpFormType = 'send-otp-form';
    const loginOtpFormType = 'login-otp-form';
    const loginGoType = 'login-go';
    const sendOtpGoType = 'send-otp-go';
    const otpTime = 120; // 120 seconds

    const loginForm = document.querySelector(`[data-type='${loginFormType}']`);
    const sendOtpForm = document.querySelector(`[data-type='${sendOtpFormType}']`);
    const loginOtpForm = document.querySelector(`[data-type='${loginOtpFormType}']`);
    const loginGoList = document.querySelectorAll(`[data-type='${loginGoType}']`);
    const sendOtpGo = document.querySelector(`[data-type='${sendOtpGoType}']`);

    if (loginForm)
        loginForm.addEventListener('submit', async (e) => {
            e.preventDefault();

            if (loginForm.dataset.loading === 'true')
                return;

            const formData = new URLSearchParams();
            formData.append('action', 'ajax_login');
            formData.append('security', ajax_login_object.nonce);
            const form = new FormData(loginForm);
            for (let [name, value] of form.entries()) {
                formData.append(name, value);
            }

            loginForm.dataset.loading = 'true';
            const response = await fetch(ajax_login_object.url, {
                method: "POST",
                body: formData,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                }
            });
            loginForm.dataset.loading = 'false';
            const data = await response.json();

            if (!response.ok)
                Toastify({
                    text: data.data,
                    duration: 3000,
                    gravity: "top", // `top` or `bottom`
                    position: "center", // `left`, `center` or `right`
                    stopOnFocus: true, // Prevents dismissing of toast on hover
                    style: {
                        background: "var(--color-red-500)",
                        borderRadius: "8px",
                        fontSize: "var(--text-body-s)"
                    }
                }).showToast();

            if (response.ok) {
                Toastify({
                    text: 'شما با موفقیت وارد شدید.',
                    duration: 3000,
                    gravity: "top", // `top` or `bottom`
                    position: "center", // `left`, `center` or `right`
                    stopOnFocus: true, // Prevents dismissing of toast on hover
                    style: {
                        background: "var(--color-green-500)",
                        borderRadius: "8px",
                        fontSize: "var(--text-body-s)"
                    }
                }).showToast();
                window.location.reload();
            }
        });

    if (loginGoList.length)
        loginGoList.forEach(loginGo =>
            loginGo.addEventListener('click', () => {
                if (loginForm) loginForm.dataset.active = 'true';
                if (sendOtpForm) sendOtpForm.dataset.active = 'false';
                if (loginOtpForm) loginOtpForm.dataset.active = 'false';
            }));

    if (sendOtpGo)
        sendOtpGo.addEventListener('click', () => {
            if (loginForm) loginForm.dataset.active = 'false';
            if (sendOtpForm) sendOtpForm.dataset.active = 'true';
            if (loginOtpForm) loginOtpForm.dataset.active = 'false';
            checkExistsTimer();
        });

    if (sendOtpForm)
        sendOtpForm.addEventListener('submit', async (e) => {
            e.preventDefault();

            if (sendOtpForm.dataset.loading === 'true')
                return;

            const formData = new URLSearchParams();
            formData.append('action', 'ajax_send_otp');
            formData.append('security', ajax_send_otp_object.nonce);
            const form = new FormData(sendOtpForm);
            for (let [name, value] of form.entries()) {
                formData.append(name, value);
            }

            sendOtpForm.dataset.loading = 'true';
            const response = await fetch(ajax_send_otp_object.url, {
                method: "POST",
                body: formData,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                }
            });
            sendOtpForm.dataset.loading = 'false';
            const data = await response.json();

            if (!response.ok)
                Toastify({
                    text: data.data,
                    duration: 3000,
                    gravity: "top", // `top` or `bottom`
                    position: "center", // `left`, `center` or `right`
                    stopOnFocus: true, // Prevents dismissing of toast on hover
                    style: {
                        background: "var(--color-red-500)",
                        borderRadius: "8px",
                        fontSize: "var(--text-body-s)"
                    }
                }).showToast();

            if (response.ok) {
                Toastify({
                    text: 'کد برای شما ارسال شد.',
                    duration: 3000,
                    gravity: "top", // `top` or `bottom`
                    position: "center", // `left`, `center` or `right`
                    stopOnFocus: true, // Prevents dismissing of toast on hover
                    style: {
                        background: "var(--color-green-500)",
                        borderRadius: "8px",
                        fontSize: "var(--text-body-s)"
                    }
                }).showToast();

                if (loginForm) loginForm.dataset.active = 'false';
                if (sendOtpForm) sendOtpForm.dataset.active = 'false';
                if (loginOtpForm) loginOtpForm.dataset.active = 'true';

                localStorage.setItem('otp', JSON.stringify({mobile: formData.get('mobile'), iat: new Date()}));
                runTimer();
            }
        });

    if (loginOtpForm)
        loginOtpForm.addEventListener('submit', async (e) => {
            e.preventDefault();

            if (loginOtpForm.dataset.loading === 'true')
                return;

            const currentOtp = JSON.parse(localStorage.getItem('otp'));

            const formData = new URLSearchParams();
            formData.append('action', 'ajax_login_otp');
            formData.append('security', ajax_login_otp_object.nonce);
            formData.append('mobile', currentOtp.mobile);
            const form = new FormData(loginOtpForm);
            for (let [name, value] of form.entries()) {
                formData.append(name, value);
            }

            loginOtpForm.dataset.loading = 'true';
            const response = await fetch(ajax_login_otp_object.url, {
                method: "POST",
                body: formData,
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                }
            });
            loginOtpForm.dataset.loading = 'false';
            const data = await response.json();

            if (!response.ok)
                Toastify({
                    text: data.data,
                    duration: 3000,
                    gravity: "top", // `top` or `bottom`
                    position: "center", // `left`, `center` or `right`
                    stopOnFocus: true, // Prevents dismissing of toast on hover
                    style: {
                        background: "var(--color-red-500)",
                        borderRadius: "8px",
                        fontSize: "var(--text-body-s)"
                    }
                }).showToast();

            if (response.ok) {
                Toastify({
                    text: 'شما با موفقیت وارد شدید.',
                    duration: 3000,
                    gravity: "top", // `top` or `bottom`
                    position: "center", // `left`, `center` or `right`
                    stopOnFocus: true, // Prevents dismissing of toast on hover
                    style: {
                        background: "var(--color-green-500)",
                        borderRadius: "8px",
                        fontSize: "var(--text-body-s)"
                    }
                }).showToast();

                window.location.reload();
            }
        });


    const otpTimerType = 'otp-timer';
    const otpTimer = document.querySelector(`[data-type='${otpTimerType}']`);

    function checkExistsTimer() {
        const currentOtp = JSON.parse(localStorage.getItem('otp'));
        if (currentOtp && currentOtp.iat && new Date(currentOtp.iat).getTime() + otpTime * 1000 > new Date().getTime() + 1000) {
            if (loginForm) loginForm.dataset.active = 'false';
            if (sendOtpForm) sendOtpForm.dataset.active = 'false';
            if (loginOtpForm) loginOtpForm.dataset.active = 'true';
            runTimer();
        } else {
            localStorage.removeItem('otp');
        }
    }
    checkExistsTimer();

    function runTimer() {
        const currentOtp = JSON.parse(localStorage.getItem('otp'));

        const interval = setInterval(() => {
            const expend = Math.floor((new Date().getTime() - new Date(currentOtp.iat).getTime()) / 1000);
            const remain = otpTime - expend;
            otpTimer.innerText = remain;

            if (remain < 1) {
                clearInterval(interval);
                if (loginForm) loginForm.dataset.active = 'false';
                if (sendOtpForm) sendOtpForm.dataset.active = 'true';
                if (loginOtpForm) loginOtpForm.dataset.active = 'false';
            }
        }, 1000);
    }

    const otpBoxType = 'otp-box';
    const otpBox = document.querySelector(`[data-type='${otpBoxType}']`);

    if (otpBox) {
        const input = otpBox.querySelector('input[type=hidden]');
        const digits = otpBox.querySelectorAll('input[type=number]');

        digits.forEach((digit, i) => {
            digit.addEventListener('input', () => {
                let newValue = digit.value;
                newValue = newValue[newValue.length - 1];
                digit.value = newValue;

                input.value = '';
                for (let i = 0; i < digits.length; i++)
                    input.value += digits[i].value;

                if (i < digits.length - 1) digits[i + 1].focus();
            });
        });
    }
});