document.addEventListener('DOMContentLoaded', () => {
    const swipers = document.querySelectorAll(`[data-type="swiper"]`);

    let swiperNavList = {};
    swipers.forEach(swiperEl => {
        if (swiperEl.dataset.size !== "gallery-nav") return;

        const size = swiperEl.dataset.size ?? "gallery-nav"; // gallery-nav
        const loop = (swiperEl.dataset.loop ?? "false") === 'true';
        const free = (swiperEl.dataset.free ?? "true") === 'true';
        const id = swiperEl.dataset.id ?? `s-${crypto.randomUUID().split('-')[4]}`;
        swiperEl.id = id;

        const swiper = new Swiper(`#${id} .swiper`, {
            direction: 'horizontal',
            loop: loop,
            freeMode: free,
            autoHeight: false,
            wrapperSize: true,
            spaceBetween: 4,
            keyboard: {
                enabled: true,
            },

            breakpoints: {
                0: {
                    slidesPerView: size === "gallery-nav" ? 4.5 : 1,
                },
                480: {
                    slidesPerView: size === "gallery-nav" ? 5.5 : 1,
                },
                580: {
                    slidesPerView: size === "gallery-nav" ? 6.5 : 1,
                },
                670: {
                    slidesPerView: size === "gallery-nav" ? 7.5 : 1,
                },
                768: {
                    slidesPerView: size === "gallery-nav" ? 8.5 : 1,
                },
                900: {
                    slidesPerView: size === "gallery-nav" ? 10.5 : 1,
                },
                1024: {
                    slidesPerView: size === "gallery-nav" ? 12.5 : 1,
                },
            },
        });

        swiperNavList[id] = swiper;
    });

    swipers.forEach(swiperEl => {
        if (swiperEl.dataset.size === "gallery-nav") return;

        const size = swiperEl.dataset.size ?? "product"; // product category brand special-offer full
        const loop = (swiperEl.dataset.loop ?? "false") === 'true';
        const play = (swiperEl.dataset.play ?? "false") === 'true';
        const free = (swiperEl.dataset.free ?? "true") === 'true';
        const id = swiperEl.dataset.id ?? `s-${crypto.randomUUID().split('-')[4]}`;
        swiperEl.id = id;
        const navId = swiperEl.dataset.nav;
        const nav = !navId ? undefined : swiperNavList[navId];

        const swiper = new Swiper(`#${id} .swiper`, {
            direction: 'horizontal',
            loop: loop,
            freeMode: free,
            autoHeight: false,
            wrapperSize: true,
            spaceBetween: 4,
            keyboard: {
                enabled: true,
            },
            autoplay: play ? {
                delay: 2500,
                disableOnInteraction: false,
            } : undefined,
            navigation: {
                nextEl: `#${id} [data-type=swiper-next]`,
                prevEl: `#${id} [data-type=swiper-prev]`,
            },
            thumbs: !nav ? undefined : {
                swiper: nav,
            },
            breakpoints: {
                0: {
                    slidesPerView: size === "full" ? 1 : size === "product" ? 1.5 : size === "product-inline" ? 1.5 : size === "category" ? 1.5 : size === "brand" ? 3 :
                        size === "special-offer" ? 1.5 : 2,
                },
                480: {
                    slidesPerView: size === "full" ? 1 : size === "product" ? 2 : size === "product-inline" ? 2 : size === "category" ? 2 : size === "brand" ? 4 :
                        size === "special-offer" ? 2 : 2,
                },
                580: {
                    slidesPerView: size === "full" ? 1 : size === "product" ? 2 : size === "product-inline" ? 2.5 : size === "category" ? 2.5 : size === "brand" ? 4.5 :
                        size === "special-offer" ? 2.5 : 2.5,
                },
                670: {
                    slidesPerView: size === "full" ? 1 : size === "product" ? 3 : size === "product-inline" ? 3 : size === "category" ? 3 : size === "brand" ? 5 :
                        size === "special-offer" ? 3 : 3,
                },
                768: {
                    slidesPerView: size === "full" ? 1 : size === "product" ? 3.5 : size === "product-inline" ? 3.5 : size === "category" ? 3.5 : size === "brand" ? 5.5 :
                        size === "special-offer" ? 3.5 : 3.5,
                },
                900: {
                    slidesPerView: size === "full" ? 1 : size === "product" ? 4 : size === "product-inline" ? 4 : size === "category" ? 4 : size === "brand" ? 6 :
                        size === "special-offer" ? 4 : 4,
                },
                1024: {
                    slidesPerView: size === "full" ? 1 : size === "product" ? 5 : size === "product-inline" ? 3 : size === "category" ? 5 : size === "brand" ? 6 :
                        size === "special-offer" ? 6 : 8,
                },
            },
        });
    });
});