<?php


use Services\dtos\QaDto;

function acf_block_init()
{
    if (function_exists('acf_register_block_type')) {
        acf_register_block_type(array(
            'name' => 'inline-related-products',
            'title' => 'پیشنهاد محصول',
            'description' => 'بلوک اختصاصی درج محصولات پیشنهادی در مقالات',
            'render_template' => get_template_directory() . '/inc/block/inline-related-products.php',
            'category' => 'formatting',
            'icon' => 'products',
            'keywords' => array('پیشنهاد محصول', 'پیشنهاد', 'inline related products')
        ));

        acf_register_block_type(array(
            'name' => 'inline-related-post',
            'title' => 'پیشنهاد مقاله',
            'description' => 'بلوک اختصاصی درج مقاله پیشنهادی در مقالات',
            'render_template' => get_template_directory() . '/inc/block/inline-related-post.php',
            'category' => 'formatting',
            'icon' => 'admin-links',
            'keywords' => array('پیشنهاد مقاله', 'پیشنهاد', 'inline related post')
        ));
    }
}

add_action('acf/init', 'acf_block_init');


function custom_fqa($output, $block_content, $attributes)
{

    $fqa_list = [];
    foreach ($attributes['questions'] as $faq) {
        if (empty($faq['visible']) || empty($faq['title']) || empty($faq['content']))
            continue;

        $fqa_list[] = new QaDto($faq['title'], $faq['content']);
    }

    ob_start();
    ?>

    <div class="py-4">
        <?php get_template_part("parts/fqa/fqa", null, ["fqa_list" => $fqa_list]); ?>
    </div>

    <?php
    return ob_get_clean();
}

add_filter('rank_math/schema/block/faq/content', 'custom_fqa', 10, 3);