<?php

use Services\ProductService;

$product_ids = get_field('inline_choose_products') ?? [];

$product_service = new ProductService();
$products = $product_service->getProducts($product_ids);
?>

<?php if (!is_admin()) { ?>
    <div class="py-4">
        <?php get_template_part("parts/product-slider/product-slider", null,
            [
                "products" => $products,
                "title" => 'محصولات مرتبط',
                "icon_name" => "package-fill",
                "size" => "product-inline",
            ]);
        ?>
    </div>
    <?php return; ?>
<?php } ?>

<div class="m-products">
    <?php foreach ($products as $product) { ?>
        <div class="m-product">
            <div class="m-product-image-box">
                <?php if (!empty($product->image)) { ?>
                    <img src="<?= $product->image->src ?>" alt="<?= $product->image->alt ?>"/>
                <?php } ?>
            </div>

            <div class="m-product-info">
                <span class="m-product-category"><?= $product->category ?></span>
                <span class="m-product-title"><?= $product->title ?></span>
            </div>

            <div class="m-product-price-box">
                <?php if ($product->discount > 0) { ?>
                    <span class="m-product-price-discount"><?= $product->regular_price ?> تومانء</span>
                <?php } ?>
                <span class="m-product-price-sale"><?= $product->sale_price ?> تومانء</span>
            </div>
        </div>
    <?php } ?>
</div>
