<?php

function verify_license() {
	$publicKey = <<<EOD
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwCicYmHLxf4C11+kfBmB
VAJRR1g9bOG+qGSPUi6lZS4qA+A52IcSTmLrwKs7RILXKjte531Mot7N05JcRgeU
SBVeQd9L462YuLjV0rbs12lZeY+laNMp9v58iVa6zFDZkvGcxjs4Vzrvgf8B3lyk
AJDGurmXhHsaF7JCk9m6odcuHQ9ZoAxBfChXfQMNlBye73XMc9drLeDClhlA7pMZ
rVuksEjtjjhVEpa3qFUbdgaPnZmvDCTB3L5QqKxBg8ZrXdMaKQAAL3awT89wBVbB
niOF1uhpqIfHuwYekGQHeZV6YikUkXay2UetYHpfLWkr/R+0xY8WbX5Tk1OK1BKl
AQIDAQAB
-----END PUBLIC KEY-----
EOD;
	$licenseKey = get_option( 'license_key' );
	if (empty($licenseKey)) {
		return false;
	}

	$jsonString = base64_decode($licenseKey);
	if ($jsonString === false) {
		return false;
	}

	$licenseObject = json_decode($jsonString);
	if ($licenseObject === null || !isset($licenseObject->data) || !isset($licenseObject->signature)) {
		return false;
	}

	$data_b64 = $licenseObject->data;
	$signature_b64 = $licenseObject->signature;

	$signature = base64_decode($signature_b64);
	if ($signature === false) {
		return false;
	}

	$data = base64_decode($data_b64);

	$isValid = openssl_verify($data, $signature, $publicKey, OPENSSL_ALGO_SHA256);

	if ($isValid !== 1) {
		return false;
	}

	$dataJson = base64_decode($data_b64);
	$dataObject = json_decode($dataJson);

	if ($dataObject === null || !isset($dataObject->domain)) {
		return false;
	}

	$siteUrl = home_url();
	$actualDomain = parse_url($siteUrl, PHP_URL_HOST);
	if (substr($actualDomain, 0, 4) === 'www.') {
		$actualDomain = substr($actualDomain, 4);
	}

	return strtolower($dataObject->domain) === strtolower($actualDomain);
}

add_action( 'admin_init', 'register_license_setting' );
function register_license_setting() {
	register_setting(
		'general',
		'license_key'
	);

	add_settings_field(
		'license_key_field',
		'لایسنس قالب',
		'license_field_html',
		'general'
	);
}

function license_field_html() {
	$value = get_option( 'license_key', '' );
	echo '<textarea id="license_key_field" name="license_key" class="regular-text">' .
	    esc_textarea($value) .
	'</textarea>';
	echo '<p class="description">لایسنس قالب "ماحامیتیم" را وارد نمایید.</p>';
}

add_action( 'admin_init', 'admin_license_check' );
function admin_license_check() {
	if ( isset( $GLOBALS['pagenow'] ) && ($GLOBALS['pagenow'] === 'options.php' || $GLOBALS['pagenow'] === 'options-general.php') ) {
        return;
    }

	if ( ! verify_license() ) {
		$settings_url = admin_url( 'options-general.php' );
		wp_die(
			'<h2>لایسنس شما معتبر نیست. </h2>' .
					'<p> با مراجعه به 
						<a href="' . esc_url( $settings_url ) . '">' . 'تنظیمات' . '</a>'.
					' لایسنس خود را فعال نمایید.' .
					'</p>',
			'Invalid License',
			[ 'response' => 403 ]
		);
	}
}

add_action( 'template_redirect', 'frontend_license_check' );
function frontend_license_check() {
	if ( is_admin() )
		return;

	if ( ! verify_license() ) {
		wp_die( 'سایت قابل دسترسی نیست. با مدیر سایت ارتباط بگیرید.', '', [ 'response' => 503 ] );
	}
}