<?php

function add_theme_menu()
{
    add_action('wp_nav_menu_item_custom_fields', 'add_menu_item_fields', 10, 4);
    add_action('wp_update_nav_menu_item', 'save_menu_item_fields', 10, 3);

    register_nav_menus(array(
        'primary' => "فهرست اصلی",
    ));
}

function add_menu_item_fields($item_id, $item, $depth, $args)
{
    $icon_id = get_post_meta($item_id, '_menu_item_icon', true);

    ?>
    <p class="description description-wide">
        <label for="menu-item-icon-<?= $item_id; ?>">
            آیکون
            <br/>
            <span class="menu-item-icon-wrapper" data-event="image-uploader" data-active-script="false">
                <span class="menu-item-icon-preview" data-type="iu-image">
                    <?php if ($icon_id)
                        echo wp_get_attachment_image($icon_id, 'full');
                    ?>
                </span>
                <input type="hidden" name="menu-item-icon[<?= $item_id; ?>]"
                       value="<?= esc_attr($icon_id) ?>"
                       data-type="iu-input"
                />
                <button type="button" class="button button-secondary" data-type="iu-add">انتخاب تصویر</button>
                <button type="button" class="button button-link-delete"
                        <?= $icon_id ? '' : 'disabled' ?>
                        data-type="iu-remove"
                >
                    حذف تصویر
                </button>
            </span>
        </label>
    </p>
    <?php
}

function save_menu_item_fields($menu_id, $menu_item_db_id, $args)
{
    if (isset($_POST['menu-item-icon'][$menu_item_db_id])) {
        $sanitized_data = absint($_POST['menu-item-icon'][$menu_item_db_id]);
        update_post_meta($menu_item_db_id, '_menu_item_icon', $sanitized_data);
    } else {
        delete_post_meta($menu_item_db_id, '_menu_item_icon');
    }
}