<?php

function theme_enqueue_assets()
{
    wp_enqueue_style(
        'style-main',
        get_stylesheet_uri(),
        [],
        filemtime(get_template_directory() . '/style.css')
    );

    wp_enqueue_style(
        'style-tailwind',
        get_template_directory_uri() . '/assets/css/tailwind.css',
        [],
        filemtime(get_template_directory() . '/assets/css/tailwind.css')
    );

    wp_enqueue_style(
        'style-swiper',
        get_template_directory_uri() . '/assets/css/swiper.css',
        [],
        filemtime(get_template_directory() . '/assets/css/swiper.css')
    );

    wp_enqueue_style(
        'style-toast',
        get_template_directory_uri() . '/assets/css/toast.css',
        [],
        filemtime(get_template_directory() . '/assets/css/toast.css')
    );


	wp_enqueue_script(
		'script-setup',
		get_template_directory_uri() . '/assets/js/setup.js',
		[],
		filemtime(get_template_directory() . '/assets/js/setup.js'),
		true // Load the script in the footer
	);

    wp_enqueue_script(
        'script-main',
        get_template_directory_uri() . '/assets/js/main.js',
        [],
        filemtime(get_template_directory() . '/assets/js/main.js'),
        true // Load the script in the footer
    );

    wp_enqueue_script(
        'script-searchbar',
        get_template_directory_uri() . '/assets/js/searchbar.js',
        [],
        filemtime(get_template_directory() . '/assets/js/searchbar.js'),
        true // Load the script in the footer
    );

	wp_enqueue_script(
		'script-my-swiper',
		get_template_directory_uri() . '/assets/js/my-swiper.js',
		[],
		filemtime(get_template_directory() . '/assets/js/my-swiper.js'),
		true // Load the script in the footer
	);

    wp_enqueue_script(
        'script-swiper',
        get_template_directory_uri() . '/assets/js/swiper.js',
        [],
        filemtime(get_template_directory() . '/assets/js/swiper.js'),
        true // Load the script in the footer
    );

    wp_enqueue_script(
        'script-cart',
        get_template_directory_uri() . '/assets/js/cart.js',
        [],
        filemtime(get_template_directory() . '/assets/js/cart.js'),
        true // Load the script in the footer
    );

    wp_enqueue_script(
        'script-city',
        get_template_directory_uri() . '/assets/js/city.js',
        [],
        filemtime(get_template_directory() . '/assets/js/city.js'),
        true // Load the script in the footer
    );

    wp_enqueue_script(
        'script-login',
        get_template_directory_uri() . '/assets/js/login.js',
        [],
        filemtime(get_template_directory() . '/assets/js/login.js'),
        true // Load the script in the footer
    );

    wp_enqueue_script( 'wc-cart-fragments' );

    wp_enqueue_script(
        'script-toast',
        get_template_directory_uri() . '/assets/js/toast.js',
        [],
        filemtime(get_template_directory() . '/assets/js/toast.js'),
        true // Load the script in the footer
    );
}

add_action('wp_enqueue_scripts', 'theme_enqueue_assets');

function admin_enqueue_assets()
{
    wp_enqueue_media();

    wp_enqueue_style(
        'admin-style-block',
        get_template_directory_uri() . '/assets/css/admin/block.css',
        [],
        filemtime(get_template_directory() . '/assets/css/admin/block.css'),
    );

    wp_enqueue_style(
        'admin-style-menu',
        get_template_directory_uri() . '/assets/css/admin/menu.css',
        [],
        filemtime(get_template_directory() . '/assets/css/admin/menu.css'),
    );

    wp_enqueue_script(
        'admin-script-media-uploader',
        get_template_directory_uri() . '/assets/js/admin/media-uploader.js',
        [],
        filemtime(get_template_directory() . '/assets/js/admin/media-uploader.js'),
        true // Load the script in the footer
    );
}

add_action('admin_enqueue_scripts', 'admin_enqueue_assets');