<?php
require_once get_template_directory() . '/inc/setup/script.php';
require_once get_template_directory() . '/inc/setup/menu.php';
require_once get_template_directory() . '/inc/setup/license.php';

function theme_setup()
{
    add_theme_support('title-tag');
    add_theme_support( 'custom-logo', array( ) );
    add_theme_menu();
}

add_action('after_setup_theme', 'theme_setup');

function allow_svg_upload( $mimes ) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter( 'upload_mimes', 'allow_svg_upload' );

function add_svg_to_upload_mimes($mimes)
{
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'add_svg_to_upload_mimes');

function custom_excerpt_length( $length ): int
{
    return 70;
}
add_filter( 'excerpt_length', 'custom_excerpt_length' );

function custom_excerpt_more( $more ): string
{
    return '...';
}
add_filter( 'excerpt_more', 'custom_excerpt_more' );

function activate_gutenberg_product( $can_edit, $post_type ) {
    if ( $post_type == 'product' ) {
        $can_edit = true;
    }
    return $can_edit;
}
add_filter( 'use_block_editor_for_post_type', 'activate_gutenberg_product', 10, 2 );

function enable_taxonomy_rest( $args ) {
    $args['show_in_rest'] = true;
    return $args;
}
add_filter( 'woocommerce_taxonomy_args_product_cat', 'enable_taxonomy_rest' );
add_filter( 'woocommerce_taxonomy_args_product_tag', 'enable_taxonomy_rest' );