<?php

function woocommerce_support()
{
    // TODO
    add_theme_support('woocommerce');
    add_filter('woocommerce_redirect_single_search_result', '__return_false');
    add_filter( 'woocommerce_get_notices', '__return_empty_array' );

    // Remove Woocommerce styles
     add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );
}

add_action('after_setup_theme', 'woocommerce_support');


function mini_cart_fragment($fragments)
{
    $fragments = [];

    ob_start();
    get_template_part('parts/cart-mini/cart-mini');
    $fragments['[data-type=mini-cart]'] = ob_get_clean();

    ob_start();
    get_template_part('parts/cart-mini-2/cart-mini-2');
    $fragments['[data-type=mini-cart-2]'] = ob_get_clean();

    ob_start();
    get_template_part('parts/cart-widget/cart-widget', null, ['page'=>'cart']);
    $fragments['[data-type=cart-widget-cart]'] = ob_get_clean();

    ob_start();
    get_template_part('parts/cart-widget/cart-widget', null, ['page'=>'checkout']);
    $fragments['[data-type=cart-widget-checkout]'] = ob_get_clean();

    return $fragments;
}

add_filter('woocommerce_add_to_cart_fragments', 'mini_cart_fragment');

add_filter('woocommerce_checkout_fields', 'custom_override_checkout_fields');
function custom_override_checkout_fields($fields)
{
    unset($fields['billing']['billing_address_2']);
    unset($fields['billing']['billing_country']);

    $fields['billing']['billing_home_phone'] = array(
        'label'       => __('تلفن منزل', 'woocommerce'),
        'required'    => false,
        'type'        => 'number',
        'priority'    => 8
    );

    foreach ($fields['billing'] as $name => $value) {
        $fields['billing'][$name]['class'] = array('col-span-12 sm:col-span-6');
    }

    $fields['billing']['billing_postcode']['required'] = false;
    $fields['billing']['billing_address_1']['type'] = 'textarea';
    $fields['billing']['billing_address_1']['label'] = 'نشانی';
    $fields['billing']['billing_phone']['required'] = true;
    $fields['billing']['billing_phone']['type'] = 'number';
    $fields['billing']['billing_phone']['label'] = 'تلفن همراه';
    $fields['billing']['billing_email']['required'] = false;

    $fields['billing']['billing_state']['class'] = array('col-span-12 sm:col-span-4');
    $fields['billing']['billing_city']['class'] = array('col-span-12 sm:col-span-4');
    $fields['billing']['billing_postcode']['class'] = array('col-span-12 sm:col-span-4');
    $fields['billing']['billing_address_1']['class'] = array('col-span-12');
    $fields['billing']['billing_email']['class'] = array('col-span-12');


    $fields['billing']['billing_first_name']['priority'] = 1;
    $fields['billing']['billing_last_name']['priority'] = 2;
    $fields['billing']['billing_state']['priority'] = 3;
    $fields['billing']['billing_city']['priority'] = 4;
    $fields['billing']['billing_postcode']['priority'] = 5;
    $fields['billing']['billing_address_1']['priority'] = 6;
    $fields['billing']['billing_phone']['priority'] = 7;
    $fields['billing']['billing_home_phone']['priority'] = 8;
    $fields['billing']['billing_email']['priority'] = 9;
    return $fields;
}
?>