<?php

use Services\dtos\PostDto;
use services\dtos\SocialLinkDto;
use Services\enums\SliderType;
use Services\GeneralService;

$category_id = get_queried_object_id();
$page_number = get_page_from_url();

$general_service = new GeneralService();
$results = $general_service->getBlogPosts();
$posts = $results['posts'];
$pages = $results['pages'];
$socials = $general_service->getSocialLinks(SliderType::FooterMainSocials);

/* @var array{post: ?PostDto, social: ?SocialLinkDto, widths: array{lg: int, md: int, sm: int}, columns: array{lg: int, md: int, sm: int}}[] $items */
$items = [];
$default_class = "lg:w-1/3 md:w-1/2 w-full";

if (!empty($posts))
    $items[] = ['post' => $posts[0], 'class' => 'lg:w-2/3 md:w-1/2 w-full'];

for ($i = 1; $i < sizeof($posts); $i++) {
    $items[] = ['post' => $posts[$i], 'class' => $default_class];
}

function add_to_array($array, $social, $position = 0)
{
    array_splice($array, $position, 0, array($social));
    return $array;
}

if (sizeof($posts) > 0 && sizeof($socials) > 0) {
    $item = ['social' => $socials[0], 'class' => $default_class];
    $items = add_to_array($items, $item, 1);
}

if (sizeof($posts) == 1 && sizeof($socials) > 1) {
    $item = ['social' => $socials[1], 'class' => $default_class];
    $items = add_to_array($items, $item, 2);
}

if (sizeof($posts) == 1 && sizeof($socials) > 2) {
    $item = ['social' => $socials[2], 'class' => $default_class];
    $items = add_to_array($items, $item, 3);
}

if (sizeof($posts) == 2 && sizeof($socials) > 1) {
    $item = ['social' => $socials[1], 'class' => $default_class];
    $items = add_to_array($items, $item, 3);
}

if (sizeof($posts) == 2 && sizeof($socials) > 2) {
    $item = ['social' => $socials[2], 'class' => $default_class];
    $items = add_to_array($items, $item, 4);
}

if (sizeof($posts) == 3 && sizeof($socials) > 1) {
    $item = ['social' => $socials[1], 'class' => $default_class];
    $items = add_to_array($items, $item, 4);
}

if (sizeof($posts) == 3 && sizeof($socials) > 2) {
    $item = ['social' => $socials[2], 'class' => $default_class];
    $items = add_to_array($items, $item, 5);
}

if (sizeof($posts) == 4 && sizeof($socials) > 1) {
    $item = ['social' => $socials[1], 'class' => $default_class];
    $items = add_to_array($items, $item, 5);
}

if (sizeof($posts) == 4 && sizeof($socials) > 2) {
    $item = ['social' => $socials[2], 'class' => $default_class];
    $items = add_to_array($items, $item, 6);
}

if (sizeof($posts) > 4 && sizeof($socials) > 1) {
    $item = ['social' => $socials[1], 'class' => $default_class];
    $items = add_to_array($items, $item, 3);
}

if (sizeof($posts) > 4 && sizeof($socials) > 2) {
    $item = ['social' => $socials[2], 'class' => $default_class];
    $items = add_to_array($items, $item, 6);
}

function get_item($item): void
{ ?>
    <li class="p-3 h-fit <?= $item['class'] ?>">
        <?php if (empty($item['post'])) { ?>
            <?php get_template_part('parts/social-cart/social-cart', null,
                    ['social' => $item['social']]);
            ?>
        <?php } else { ?>
            <?php get_template_part('parts/post-card-1/post-card-1', null,
                    ['post' => $item['post']]);
            ?>
        <?php } ?>
    </li>
<?php } ?>

<?php get_header(); ?>

    <main>
        <div class="container-md mt-6 flex flex-col">
            <?php get_template_part("parts/breadcrumb/breadcrumb"); ?>

            <div class="mt-6 flex">
                <?php if (sizeof($posts) == 0) { ?>
                    <div class="w-full text-detail">مقاله‌ای یافت نشد</div>
                <?php } else { ?>
                    <ul class="w-full relative flex flex-wrap" data-type="blog-items"
                        data-columns-lg="3" data-columns-md="2" data-columns-sm="1">
                        <?php foreach ($items as $item) { ?>
                            <?php get_item($item); ?>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>

            <div class="w-fit h-fit self-center mt-1">
                <?php get_template_part("parts/pagination/pagination", null,
                        ['page' => $page_number, 'total' => $pages]
                ); ?>
            </div>
        </div>
    </main>

<?php get_footer(); ?>