<?php
$archive_product_layout = get_theme_mod('archive_product_layout_setting', 'layout-1');

get_header();
get_template_part("pages/archive-product/" . $archive_product_layout);
get_footer();

?>

<script>
    {
        const urlParams = new URLSearchParams(window.location.search);
        const searchTerm = urlParams.get('s') ?? '';

        let data = JSON.parse(localStorage.getItem("search-history")) ?? [];

        if (searchTerm.length > 2) {
            data = Array.from(new Set([searchTerm, ...data])).slice(0, 8);
            localStorage.setItem('search-history', JSON.stringify(data));
        }
    }
</script>
