<?php

use Services\ProductService;

$product_service = new ProductService();
$cart = $product_service->getCart();

?>


<main>
    <div class="container-md mt-6 flex flex-col">
        <?php get_template_part("parts/breadcrumb/breadcrumb"); ?>

        <div class="grid grid-cols-12 gap-6 mt-6">
            <div class="col-span-12 lg:col-span-7 flex flex-col gap-y-4">
                <div class="flex flex-col p-1 bg-primary-light rounded-3xl" data-type="detail">
                    <div class="flex flex-row text-body-s gap-x-4 items-center py-3 px-4 group cursor-pointer"
                         data-type="detail-activator" data-active="false">
                            <span class="text-primary">
                                <?= get_icon("basket-fill", IconSize::Large) ?>
                            </span>
                        <span class="grow">محصولات در سبد</span>
                        <span class="text-body-s text-primary transition group-hover:text-primary-dark self-center group-data-[active=true]:rotate-180">
                            <?= get_icon("caret-down-fill", IconSize::Large) ?>
                        </span>
                    </div>

                    <div class="grid grid-rows-[0fr] transition-all data-[active=true]:grid-rows-[1fr]"
                         data-type="detail-content" data-active="false">
                        <div class="overflow-hidden">
                            <?php get_template_part("parts/cart-mini-2/cart-mini-2"); ?>
                        </div>
                    </div>
                </div>

                <form class="flex flex-col gap-y-4 group/checkout-form" id="checkout-form" data-type="checkout-form">
                    <?php wp_nonce_field('woocommerce-process-checkout', 'woocommerce-process-checkout-nonce'); ?>
                    <div class="flex flex-col p-1 bg-primary-light rounded-3xl" data-type="detail">
                        <div class="flex flex-row text-body-s gap-x-4 items-center py-3 px-4 group cursor-pointer"
                             data-type="detail-activator" data-active="true">
                            <span class="text-primary">
                                <?= get_icon("map-pin-fill", IconSize::Large) ?>
                            </span>
                            <span class="grow">نشانی و اطلاعات تماس</span>
                            <span class="text-body-s text-primary transition group-hover:text-primary-dark self-center group-data-[active=true]:rotate-180">
                            <?= get_icon("caret-down-fill", IconSize::Large) ?>
                        </span>
                        </div>

                        <div class="grid grid-rows-[0fr] transition-all data-[active=true]:grid-rows-[1fr]"
                             data-type="detail-content" data-active="true">
                            <div class="overflow-hidden">
                                <?php get_template_part("parts/cart-info/cart-info"); ?>
                            </div>
                        </div>
                    </div>

                    <div class="flex flex-col p-1 bg-primary-light rounded-3xl" data-type="detail">
                        <div class="flex flex-row text-body-s gap-x-4 items-center py-3 px-4 group cursor-pointer"
                             data-type="detail-activator" data-active="true">
                            <span class="text-primary">
                                <?= get_icon("credit-card-fill", IconSize::Large) ?>
                            </span>
                            <span class="grow">نحوه پرداخت</span>
                            <span class="text-body-s text-primary transition group-hover:text-primary-dark self-center group-data-[active=true]:rotate-180">
                            <?= get_icon("caret-down-fill", IconSize::Large) ?>
                        </span>
                        </div>

                        <div class="grid grid-rows-[0fr] transition-all data-[active=true]:grid-rows-[1fr]"
                             data-type="detail-content" data-active="true">
                            <div class="overflow-hidden">
                                <?php get_template_part("parts/cart-gateway/cart-gateway"); ?>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-span-12 lg:col-span-5">
                <div class="sticky flex flex-col">
                    <?php get_template_part("parts/cart-widget/cart-widget", null, ['page' => 'checkout']); ?>
                </div>
            </div>
        </div>
    </div>
</main>
