<main>
    <div class="container-md mt-6 flex flex-col">
        <?php get_template_part("parts/breadcrumb/breadcrumb"); ?>

        <div class="grid grid-cols-1 lg:grid-cols-[repeat(auto-fit,minmax(0,1fr))] gap-6 flex-wrap items-center mt-6">
            <div class="w-full max-lg:col-span-full lg:col-span-5 flex flex-col bg-primary-light p-1 rounded-3xl relative group">
                <div class="px-4 py-3">
                    <div class="w-full flex-1 flex flex-row items-center gap-x-4 text-h3">
                        <span class="text-primary"><?= get_icon("ChatCircleText", IconSize::Large) ?></span>
                        <span class="grow">تماس با ما</span>
                    </div>
                </div>
                <div class="flex flex-col gap-y-1 group-data-[loading=true]:hidden h-auto">
                <span class="py-4 px-6 bg-bg rounded-2xl text-body">
                    <?php the_content(); ?>
                </span>
                </div>
            </div>
            <?php if (has_post_thumbnail()): ?>
            <div class="w-full max-lg:col-span-full lg:col-span-5 flex flex-col bg-primary-light p-1 rounded-3xl relative group">
                <div class="px-4 py-3">
                    <div class="w-full flex-1 flex flex-row items-center gap-x-4 text-h3">
                        <span class="text-primary"><?= get_icon("MapTrifold-fill", IconSize::Large) ?></span>
                        <span class="grow">نشانی</span>
                    </div>
                </div>
                <div class="flex flex-col gap-y-1 group-data-[loading=true]:hidden h-auto">
                    <span class="py-4 px-6 bg-bg rounded-2xl text-body">
                        <?php the_content(); ?>
                    </span>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <?php get_template_part("parts/brand-slider/brand-slider"); ?>
    </div>
</main>