<?php

use Services\enums\SliderType;
use Services\GeneralService;
use Services\ProductService;

$product_service = new ProductService();
$general_service = new GeneralService();

$cat_products_1 = $product_service->getSliderCatOne(SliderType::HomeSliderCatOne);
$cat_products_2 = $product_service->getSliderCatOne(SliderType::HomeSliderCatTwo);
$cat_products_3 = $product_service->getSliderCatOne(SliderType::HomeSliderCatThree);

$fqa_list = $general_service->getQaFields(SliderType::HomeQaBrand);

$grid_banner = wp_is_mobile() ? SliderType::HomeGridBannersMobile : SliderType::HomeGridBanners;
$full_banner = wp_is_mobile() ? SliderType::HomeFullWidthBannerMobile : SliderType::HomeFullWidthBanner;

?>

<main>
    <?php get_template_part("parts/hero-slider/hero-slider"); ?>
    <?php get_template_part("parts/category-slider/category-slider"); ?>
    <?php get_template_part("parts/daily-special/daily-special"); ?>


    <div class="mt-15 container-md">
        <?php get_template_part("parts/product-slider/product-slider", null,
            [
                "products" => $cat_products_1['products'],
                "title" => $cat_products_1['category']->title,
                "title_link" => $cat_products_1['category']->link,
                "icon_src" => $cat_products_1['category']->image?->src,
            ]);
        ?>
    </div>


    <?php get_template_part("parts/banner/banner", null,
        ['banner' => $grid_banner, 'size' => "grid"]); ?>


    <div class="mt-15 container-md">
        <?php get_template_part("parts/product-slider/product-slider", null,
            [
                "products" => $cat_products_2['products'],
                "title" => $cat_products_2['category']->title,
                "title_link" => $cat_products_2['category']->link,
                "icon_src" => $cat_products_2['category']->image?->src,
            ]);
        ?>
    </div>
    <?php get_template_part("parts/banner/banner", null,
        ['banner' => $full_banner, 'size' => "full"]); ?>


    <div class="mt-15 container-md">
        <?php get_template_part("parts/product-slider/product-slider", null,
            [
                "products" => $cat_products_3['products'],
                "title" => $cat_products_3['category']->title,
                "title_link" => $cat_products_3['category']->link,
                "icon_src" => $cat_products_3['category']->image?->src,
            ]);
        ?>
    </div>

    <?php get_template_part("parts/brand-slider/brand-slider"); ?>
    <?php get_template_part("parts/blog-grid/blog-grid"); ?>

    <div class="mt-15 container-md">
        <?php get_template_part("parts/fqa/fqa", null, ["fqa_list" => $fqa_list]); ?>
    </div>
</main>