<?php

$order_id = absint(get_query_var('order-received') ?: ($_GET['order-received'] ?? 0));
$key = sanitize_text_field($_GET['key'] ?? '');
$order = $order_id ? wc_get_order($order_id) : false;

if (empty($order) || empty($key) || $order->get_order_key() !== $key) { ?>
        <div class="" >یافت نشد</div>
    <?php
    return;
}

$payment_failed = $order->has_status(array('failed', 'cancelled'));
$paid = $order->is_paid();
$billing_email = $order->get_billing_email();
$order_items = $order->get_items(apply_filters('woocommerce_purchase_order_item_types', 'line_item'));
$totals = $order->get_order_item_totals();
$downloads = $order->get_downloadable_items();
$show_downloads = $order->has_downloadable_item() && $order->is_download_permitted();

?>

<main class="container-md">
    <div class="grid grid-cols-12 mt-6 gap-6">
        <div class="col-span-12 rounded-2xl border border-border p-4 flex flex-row items-center gap-x-3">
            <div class="flex flex-col">
                <span class="text-body-s">
                <?php if ($payment_failed) { ?>
                    پرداخت انجام نشد. لطفاً مجدداً تلاش کنید یا روش پرداخت دیگری انتخاب نمایید.
                <?php } elseif ($paid) { ?>
                    سفارش شما با موفقیت ثبت شد. از خرید شما سپاسگزاریم.
                <?php } else { ?>
                    سفارش شما ثبت شد اما پرداخت هنوز نهایی نشده است.
                <?php } ?>
                </span>
                <span class="text-caption text-muted mt-1">
                    کد سفارش: #<?= $order->get_order_number(); ?> — تاریخ: <?= wc_format_datetime($order->get_date_created()); ?>
                </span>
            </div>
        </div>

        <!-- Order Meta -->
        <div class="col-span-12 grid grid-cols-12 gap-4">
            <div class="col-span-12 lg:col-span-7 rounded-2xl border border-border p-4 bg-white">
                <div class="flex flex-row items-center justify-between mb-4">
                    <span class="text-body-s">جزئیات سفارش</span>
                    <div class="flex flex-row gap-x-2">
                        <a class="btn-primary text-body-s py-1 px-3 inline-flex items-center gap-x-2"
                           href="<?= esc_url($order->get_view_order_url()); ?>">
                            <?= get_icon('file-text') ?> مشاهده سفارش
                        </a>
                    </div>
                </div>

                <!-- Items -->
                <div class="flex flex-col divide-y divide-border rounded-lg border border-border">
                    <?php if (!empty($order_items)) {
                        foreach ($order_items as $item_id => $item) {
                            $product = $item->get_product();
                            $thumbnail = $product ? $product->get_image([64, 64], ['class' => 'rounded-md border border-border']) : '';
                            $product_name = $item->get_name();
                            $qty = $item->get_quantity();
                            $subtotal = $order->get_formatted_line_subtotal($item);
                            $meta_html = wc_display_item_meta($item, ['echo' => false]);
                            ?>
                            <div class="p-3 grid grid-cols-12 gap-3 items-center">
                                <div class="col-span-2 sm:col-span-1">
                                    <span class="inline-block"><?= $thumbnail ?></span>
                                </div>
                                <div class="col-span-10 sm:col-span-7 flex flex-col">
                                    <span class="text-body-s"><?= $product_name ?></span>
                                    <?php if ($meta_html) { ?>
                                        <span class="text-caption text-muted mt-1"><?= $meta_html ?></span>
                                    <?php } ?>
                                </div>
                                <div class="col-span-6 sm:col-span-2 text-body-s text-muted sm:text-center">
                                    تعداد: <?= $qty ?></div>
                                <div class="col-span-6 sm:col-span-2 text-body-s text-left sm:text-right"><?= $subtotal ?></div>
                            </div>
                        <?php }
                    } else { ?>
                        <div class="p-3">
                            <span class="text-body-s">آیتمی برای این سفارش ثبت نشده است.</span>
                        </div>
                    <?php } ?>
                </div>

                <!-- Totals -->
                <?php if (!empty($totals)) { ?>
                    <div class="mt-4 rounded-lg border border-border divide-y divide-border bg-neutral-50">
                        <?php foreach ($totals as $total) { ?>
                            <div class="px-4 py-3 grid grid-cols-12 items-center">
                                <div class="col-span-6 sm:col-span-9 text-caption text-muted"><?= $total['label']; ?></div>
                                <div class="col-span-6 sm:col-span-3 text-body-s text-left sm:text-right"><?= $total['value']; ?></div>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>

                <!-- Customer Note -->
                <?php if ($order->get_customer_note()) { ?>
                    <div class="mt-4 rounded-lg border border-border p-4 bg-neutral-50">
                        <span class="text-body-s block mb-2">یادداشت شما</span>
                        <p class="text-body-s text-muted leading-relaxed"><?= wp_kses_post($order->get_customer_note()); ?></p>
                    </div>
                <?php } ?>
            </div>

            <!-- Side Column -->
            <div class="col-span-12 lg:col-span-5 flex flex-col gap-4">
                <!-- Payment Summary -->
                <div class="rounded-2xl border border-border p-4 bg-white">
                    <div class="flex flex-row items-center gap-x-2 mb-3">
                        <span><?= get_icon('wallet2') ?></span>
                        <span class="text-body-s">اطلاعات پرداخت</span>
                    </div>
                    <div class="grid grid-cols-12 gap-y-2">
                        <div class="col-span-6 text-caption text-muted">وضعیت</div>
                        <div class="col-span-6 text-body-s">
                            <?php if ($payment_failed) { ?>
                                <span class="text-red-600">ناموفق</span>
                            <?php } elseif ($paid) { ?>
                                <span class="text-green-600">پرداخت شده</span>
                            <?php } else { ?>
                                <span class="text-amber-600">در انتظار پرداخت</span>
                            <?php } ?>
                        </div>

                        <div class="col-span-6 text-caption text-muted">روش پرداخت</div>
                        <div class="col-span-6 text-body-s"><?= $order->get_payment_method_title() ?: '—' ?></div>

                        <div class="col-span-6 text-caption text-muted">ایمیل</div>
                        <div class="col-span-6 text-body-s"><?= $billing_email ?: '—' ?></div>
                    </div>
                </div>

                <!-- Addresses -->
                <div class="rounded-2xl border border-border p-4 bg-white">
                    <div class="flex flex-row items-center gap-x-2 mb-3">
                        <span><?= get_icon('geo-alt') ?></span>
                        <span class="text-body-s">آدرس‌ها</span>
                    </div>
                    <div class="grid grid-cols-12 gap-4">
                        <div class="col-span-12 md:col-span-6 rounded-lg border border-border p-3 bg-neutral-50">
                            <span class="text-caption text-muted">آدرس صورت‌حساب</span>
                            <div class="text-body-s mt-1 leading-relaxed">
                                <?= $order->get_formatted_billing_address() ?: '—'; ?>
                            </div>
                            <?php if ($order->get_billing_phone()) { ?>
                                <div class="text-caption text-muted mt-2 flex items-center gap-x-2">
                                    <?= get_icon('telephone') ?> <?= $order->get_billing_phone(); ?>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="col-span-12 md:col-span-6 rounded-lg border border-border p-3 bg-neutral-50">
                            <span class="text-caption text-muted">آدرس ارسال</span>
                            <div class="text-body-s mt-1 leading-relaxed">
                                <?= $order->get_formatted_shipping_address() ?: ($order->get_formatted_billing_address() ?: '—'); ?>
                            </div>
                            <?php if ($order->get_shipping_method()) { ?>
                                <div class="text-caption text-muted mt-2 flex items-center gap-x-2">
                                    <?= get_icon('truck') ?> <?= $order->get_shipping_method(); ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>

                <!-- Downloads (if any) -->
                <?php if ($show_downloads && !empty($downloads)) { ?>
                    <div class="rounded-2xl border border-border p-4 bg-white">
                        <div class="flex flex-row items-center gap-x-2 mb-3">
                            <span><?= get_icon('cloud-download') ?></span>
                            <span class="text-body-s">دانلودها</span>
                        </div>
                        <div class="flex flex-col gap-y-2">
                            <?php foreach ($downloads as $download) { ?>
                                <a class="rounded-lg border border-border px-3 py-2 hover:bg-neutral-100 flex items-center gap-x-2"
                                   href="<?= esc_url($download['download_url']); ?>">
                                    <?= get_icon('file-earmark-arrow-down') ?>
                                    <span class="text-body-s"><?= $download['download_name']; ?></span>
                                </a>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>

        <!-- Back to Shop -->
        <div class="col-span-12 flex justify-end">
            <a class="btn-primary inline-flex items-center gap-x-2" href="<?= wc_get_page_permalink('shop'); ?>">
                <?= get_icon('arrow-left') ?> بازگشت به فروشگاه
            </a>
        </div>
    </div>
</main>
