<?php

use services\enums\PostType;
use Services\enums\SliderType;
use Services\GeneralService;

$post_id = get_queried_object_id();

$general_service = new GeneralService();
$post_dto = $general_service->getPostDetail();
$socials = $general_service->getSocialLinks(SliderType::FooterMainSocials);
$related_posts = $general_service->getRelatedPosts($post_id);
$related_posts[] = $related_posts[0];
$related_posts[] = $related_posts[0];
?>

<main>
    <div class="container-md mt-6 flex flex-col">
        <div class="grid grid-cols-12 gap-x-6">
            <div class="col-span-12 lg:col-span-8">
                <?php get_template_part("parts/breadcrumb/breadcrumb"); ?>

                <h1 class="text-h1 mt-4"><?= $post_dto->title ?></h1>

                <div class="mt-2 flex flex-row gap-x-2 items-center">
                    <span class="text-detail"><?= $post_dto->auther_name ?></span>
                    <span class="w-1 h-1 bg-primary rounded-full"></span>
                    <span class="text-detail"><?= format_datetime($post_dto->time) ?></span>
                </div>

                <div class="mt-8 p-1 bg-primary-light rounded-3xl">
                    <div class="rounded-2xl shadow-sm overflow-hidden">
                        <?php if (!empty($post_dto->image)) { ?>
                            <img class="w-full" src="<?= $post_dto->image->src ?>" alt="<?= $post_dto->image->alt ?>"/>
                        <?php } ?>
                    </div>
                </div>

                <div class="mt-8 product-description">
                    <?= $post_dto->content ?>
                </div>

                <?php if (!empty($post_dto->auther_desc)) { ?>
                    <div class="flex flex-col bg-primary-light rounded-3xl overflow-hidden mt-4" data-type="detail">
                        <div class="flex flex-row px-5 py-4 group cursor-pointer text-h3"
                             data-type="detail-activator" data-active="false">
                            <div class="flex-1 flex flex-row items-center gap-x-4">
                                <span class="text-primary"><?= get_icon("pen-nib-fill", IconSize::Large) ?></span>
                                <span><?= $post_dto->auther_name ?></span>
                            </div>
                            <span class="text-body-s text-primary transition group-hover:text-primary-dark self-center group-data-[active=true]:rotate-180">
                            <?= get_icon("caret-down-fill", IconSize::Large) ?>
                        </span>
                        </div>
                        <div class="grid grid-rows-[0fr] transition-all data-[active=true]:grid-rows-[1fr]"
                             data-type="detail-content" data-active="false">
                            <div class="overflow-hidden">
                                <div class="bg-white shadow-sm m-1 px-16 py-4 rounded-2xl max-md:px-4">
                                    <span><?= $post_dto->auther_desc ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>

            <div class="col-span-12 lg:col-span-4">
                <div class="sticky flex flex-col gap-y-4 top-10">
                    <?php if (!empty($post_dto->next_post)) { ?>
                        <span>مقاله بعدی</span>
                        <?php get_template_part('parts/post-card-1/post-card-1', null,
                                ['post' => $post_dto->next_post]);
                        ?>
                    <?php } ?>
                    <?php foreach ($socials as $social) { ?>
                        <?php get_template_part('parts/social-cart/social-cart', null,
                                ['social' => $social]);
                        ?>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-12 mt-9 gap-x-6">
            <div class="col-span-4 bg-primary-light p-1 rounded-3xl h-fit lg:sticky lg:top-10 max-lg:inset-0 max-lg:fixed max-lg:data-[active=true]:z-40 max-lg:transition-all max-lg:data-[active=false]:invisible max-lg:m-auto max-lg:w-11/12 max-lg:max-h-11/12 max-lg:overflow-auto"
                 data-type="dialog-content-comment-form" data-active="false">
                <?php get_template_part("parts/comment-form/comment-form", null,
                        ["post_id" => $post_id, "post_type" => PostType::Product])
                ?>
            </div>

            <div class="col-span-12 lg:col-span-8 h-fit">
                <?php get_template_part("parts/comments/comments", null,
                        ['post_id' => $post_id, "post_type" => PostType::Post]);
                ?>
            </div>
        </div>

        <?php if (!empty($related_posts)) { ?>
            <div class="mt-15 flex flex-col gap-y-6">
                <span class="text-h3">مقالات مرتبط</span>
                <div class="grid grid-cols-3 gap-8">
                    <?php foreach ($related_posts as $related_post) { ?>
                        <div class="col-span-3 md:col-span-1 h-full">
                            <?php get_template_part('parts/post-card-1/post-card-1', null,
                                    ['post' => $related_post]);
                            ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
    </div>
</main>
