<?php

use Services\dtos\CommentDto;
use services\enums\PostType;
use Services\ProductService;

$product_id = get_queried_object_id();

$product_service = new ProductService();
$product = $product_service->getDetailsProduct($product_id);
$related_products = $product_service->getRelatedProducts($product_id, 10);
$carousel_count = 5;
$images = [$product->image];
foreach ($product->variations as $variation) {
    $images[] = $variation->image;
}
$images = array_merge($images, $product->gallery);

$unique_images = [];
foreach ($images as $image) {
    $unique_images[$image->src] = $image;
}
$images = array_values($unique_images);
?>

<main>
    <div class="container-md mt-6 flex flex-col">
        <?php get_template_part("parts/breadcrumb/breadcrumb"); ?>

        <div class="mt-6 grid grid-cols-12 gap-6">
            <div class="col-span-12 lg:col-span-4 grid grid-cols-5 p-1 bg-primary-light gap-1 rounded-3xl">
                <div class="col-span-5 border border-border shadow-sm rounded-b-sm rounded-t-2xl overflow-hidden cursor-pointer"
                     data-type="dialog-activator-gallery">
                    <?= product_image($images[0]) ?>
                </div>
                <?php $i = 0; ?>
                <?php foreach (array_slice($images, 1, 5) as $image) { ?>
                    <?php $i += 1; ?>
                    <div class="col-span-1 shadow-sm overflow-hidden rounded-sm nth-[2]:rounded-br-2xl nth-[6]:rounded-bl-2xl cursor-pointer relative"
                         data-type="dialog-activator-gallery">
                        <?= product_image($image) ?>
                        <?php if ($i === 5 && sizeof($images) > 5) { ?>
                            <span class="absolute inset-0 bg-black/50 flex items-center justify-center text-white text-2xl">
                                    <?= get_icon('dots-three-outline') ?>
                                </span>
                        <?php } ?>
                    </div>
                <?php } ?>
                <?php get_template_part("parts/gallery/gallery", null, ['images' => $images]); ?>
            </div>
            <div class="col-span-12 lg:col-span-8 grid grid-cols-8 gap-6 content-start">
                <h1 class="col-span-full text-h3"> <?= $product->title ?> </h1>
                <table class="col-span-12 lg:col-span-4 h-fit">
                    <?php foreach ($product->attributes as $attribute) { ?>
                        <tr class="py-0.5">
                            <td class="text-body-s content-start min-w-30"><?= $attribute->name ?>:</td>
                            <td class="text-body-s content-start min-w-30"><?= join(", ", $attribute->options) ?></td>
                        </tr>
                    <?php } ?>
                </table>
                <div class="col-span-4 h-fit flex flex-col p-1 rounded-3xl bg-green-100 data-[stock=false]:bg-red-100 group max-lg:flex-col-reverse max-lg:fixed max-lg:inset-x-0 max-lg:-bottom-1 max-lg:z-20 max-lg:data-[active=true]:z-40 max-lg:shadow-drawer max-lg:rounded-b-none"
                     data-stock="<?= $product->in_stock ? 'true' : 'false' ?>"
                     data-type="dialog-content-product-widget" data-active="false">
                    <form class="p-6 flex flex-col gap-y-6 bg-white rounded-2xl shadow-sm group/form transition-all max-lg:group-data-[active=false]:flex-row-reverse max-lg:group-data-[active=false]:justify-between max-lg:h-20 max-lg:group-data-[active=true]:h-[50dvh] max-lg:overflow-auto scrollbar-hidden max-lg:rounded-b-none"
                          data-loading="false" data-type="add-to-cart">
                        <input name="product_id" value="<?= $product_id ?>" type="hidden">
                        <div class="flex flex-row items-center max-lg:group-data-[active=false]:hidden">
                            <span class="flex-1 text-body-s">تعداد:</span>
                            <div class="flex flex-row items-center px-1 py-0.5 border border-border gap-x-2 text-body rounded-md"
                                 data-type="quantity"
                                 data-min="<?= $product->min_quantity ?>" data-max="<?= $product->max_quantity ?>">
                                <button class="cursor-pointer p-1" data-type="quantity-plus">
                                    <?= get_icon('plus', IconSize::Small) ?>
                                </button>
                                <input name="quantity" class="w-4 text-center cursor-default"
                                       data-type="quantity-input" readonly value="0"/>
                                <button class="cursor-pointer p-1" data-type="quantity-minus">
                                    <?= get_icon('minus', IconSize::Small) ?>
                                </button>
                            </div>
                        </div>

                        <?= get_variations_selector($product->variations); ?>

                        <div class="flex flex-row items-end max-lg:group-data-[active=false]:items-baseline">
                            <span class="flex-1 text-body-s max-lg:group-data-[active=false]:hidden">قیمت نهایی:</span>
                            <div class="flex flex-col items-end">
                                <div class="flex flex-row items-center gap-x-1 data-[discount=0]:hidden" data-type="discount-box" data-discount="<?= $product->discount ?>">
                                    <span class="text-detail px-2 bg-red-500 text-white rounded-full self-start" data-type="discount">
                                        <?= $product->discount ?>%
                                    </span>
                                    <span class="text-detail text-fg-2 line-through leading-none text-left" data-type="regular-price">
                                        <?= format_price($product->regular_price) ?> تومانء
                                    </span>
                                </div>
                                <span class="text-body text-left" data-type="sale-price">
                                        <?= format_price($product->sale_price) ?> تومانء
                                </span>
                            </div>
                        </div>

                        <div class="flex flex-col">
                            <button class="items-center text-body-s btn-primary group-data-[stock=false]:btn-disabled"
                                    type="submit">
                                <span class="group-data-[loading=false]/form:hidden animate-spin w-fit">
                                    <?= get_icon("spinner-gap") ?>
                                </span>
                                <span><?= get_icon("shopping-bag", IconSize::Large) ?></span>
                                <span>افزودن به سبد خرید</span>
                            </button>
                            <div class="text-detail p-2 rounded-full hidden has-data-[active=true]:block">
                                +
                                <span data-type="cart-quantity" data-product-id="<?= $product_id ?>"></span>
                                در سبد خرید شما
                            </div>
                        </div>
                    </form>

                    <div class="flex flex-col" data-type="dialog-activator-product-widget">
                        <div class="lg:hidden pt-2 px-4 text-detail flex flex-col gap-y-1 items-center self-center w-full">
                            <span class="rounded-full w-12 h-1 bg-green-500 data-[stock=false]:bg-red-500"></span>
                        </div>

                        <div class="py-1 max-lg:py-2 px-4 flex flex-row">
                            <span class="text-body-s flex-1">وضعیت کالا:</span>
                            <div class="flex flex-row gap-x-1 items-center">
                                <span class="text-body-s" data-type="stock-message">
                                    <?= $product->in_stock ? 'آماده ارسال' : 'ناموجود' ?>
                                </span>
                                <span class="text-body-s text-green-500 group-data-[stock=false]:hidden">
                                    <?= get_icon('check-circle-fill', IconSize::Large) ?>
                                </span>
                                <span class="text-body-s text-red-500 group-data-[stock=true]:hidden">
                                    <?= get_icon('x-circle-fill', IconSize::Large) ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-9">
            <div class="flex flex-col bg-primary-light rounded-3xl overflow-hidden" data-type="detail">
                <div class="flex flex-row px-5 py-4 group cursor-pointer text-h3"
                     data-type="detail-activator" data-active="true">
                    <div class="flex-1 flex flex-row items-center gap-x-4">
                        <span class="text-primary"><?= get_icon("article-fill", IconSize::Large) ?></span>
                        <span>معرفی</span>
                    </div>
                    <span class="text-body-s text-primary transition group-hover:text-primary-dark self-center group-data-[active=true]:rotate-180">
                            <?= get_icon("caret-down-fill", IconSize::Large) ?>
                        </span>
                </div>
                <div class="grid grid-rows-[0fr] transition-all data-[active=true]:grid-rows-[1fr]"
                     data-type="detail-content" data-active="true">
                    <div class="overflow-hidden">
                        <div class="bg-white shadow-sm m-1 px-16 py-4 rounded-2xl product-description max-md:px-4">
                            <?= $product->full_desc ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-12 mt-9 gap-x-6">
            <div class="col-span-4 bg-primary-light p-1 rounded-3xl h-fit lg:sticky lg:top-10 max-lg:inset-0 max-lg:fixed max-lg:data-[active=true]:z-40 max-lg:transition-all max-lg:data-[active=false]:invisible max-lg:m-auto max-lg:w-11/12 max-lg:max-h-11/12 max-lg:overflow-auto"
                 data-type="dialog-content-comment-form" data-active="false">
                <?php get_template_part("parts/comment-form/comment-form", null,
                        ["post_id" => $product_id, "post_type" => PostType::Product])
                ?>
            </div>

            <div class="col-span-12 lg:col-span-8 h-fit">
                <?php get_template_part("parts/comments/comments", null,
                        ['post_id' => $product_id, "post_type" => PostType::Product]);
                ?>
            </div>
        </div>

        <?php if (!empty($related_products)) { ?>
            <div class="mt-9">
                <?php get_template_part("parts/product-slider/product-slider", null,
                        [
                                "products" => $related_products,
                                "title" => 'محصولات مشابه',
                                "icon_name" => 'package-fill',
                        ]);
                ?>
            </div>
        <?php } ?>
    </div>
</main>
