<?php

use Services\GeneralService;
use Services\ProductService;

function ajax_prepare_script(): void
{
    wp_localize_script(
        'script-searchbar',
        'ajax_search_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_search_nonce')
        )
    );

    wp_localize_script(
        'script-main',
        'ajax_send_comment_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_send_comment_nonce')
        )
    );

    wp_localize_script(
        'script-main',
        'ajax_comments_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_comments_nonce')
        )
    );

    wp_localize_script(
        'script-cart',
        'ajax_add_to_cart_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_add_to_cart_nonce')
        )
    );

    wp_localize_script(
        'script-cart',
        'ajax_remove_from_cart_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_remove_from_cart_nonce')
        )
    );

    wp_localize_script(
        'script-cart',
        'ajax_update_cart_quantity_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_update_cart_quantity_nonce')
        )
    );

    wp_localize_script(
        'script-cart',
        'ajax_update_cart_customer_info_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_update_cart_customer_info_nonce')
        )
    );

    wp_localize_script(
        'script-cart',
        'ajax_apply_coupon_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_apply_coupon_nonce')
        )
    );

    wp_localize_script(
        'script-cart',
        'ajax_remove_coupon_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_remove_coupon_nonce')
        )
    );

    wp_localize_script(
        'script-login',
        'ajax_login_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_login_nonce')
        )
    );

    wp_localize_script(
        'script-login',
        'ajax_login_otp_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_login_otp_nonce')
        )
    );

    wp_localize_script(
        'script-login',
        'ajax_send_otp_object',
        array(
            'url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax_send_otp_nonce')
        )
    );
}

add_action('wp_enqueue_scripts', 'ajax_prepare_script');

function ajax_search(): void
{
    if (!check_ajax_referer('ajax_search_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $search_term = $_POST['term'] ?? '';

    $product_service = new ProductService();

    try {
        $products = $product_service->search($search_term);
        wp_send_json_success($products);
    } catch (Exception $e) {
        wp_send_json_error($e->getMessage(), 406);
    }
}

add_action('wp_ajax_ajax_search', 'ajax_search');
add_action('wp_ajax_nopriv_ajax_search', 'ajax_search');

function ajax_send_comment(): void
{
    if (!check_ajax_referer('ajax_send_comment_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $post_id = intval($_POST['post_id']) ?? 0;
    $content = $_POST['content'] ?? '';
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $rate = $_POST['rate'] == null ? null : intval($_POST['rate']);

    $product_service = new ProductService();

    try {
        $product_service->sendProductComment($post_id, $content, $name, $email, $rate);
        wp_send_json_success();
    } catch (WP_Exception $e) {
        wp_send_json_error($e->getMessage(), 406);
    }
}

add_action('wp_ajax_ajax_send_comment', 'ajax_send_comment');
add_action('wp_ajax_nopriv_ajax_send_comment', 'ajax_send_comment');

function ajax_get_comments(): void
{
    if (!check_ajax_referer('ajax_comments_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $post_id = intval($_POST['post_id']);
    $page_number = intval($_POST['page_number']);

    ob_start();
    get_template_part("parts/comments/comments", null,
        ['post_id' => $post_id, 'page_number' => $page_number]);
    $html = ob_get_clean();
    wp_send_json_success(['html' => $html]);
}

add_action('wp_ajax_ajax_comments', 'ajax_get_comments');
add_action('wp_ajax_nopriv_ajax_comments', 'ajax_get_comments');


function ajax_add_to_cart(): void
{
    if (!check_ajax_referer('ajax_add_to_cart_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $product_id = intval($_POST['product_id']);
	$variation_id = intval($_POST['variation_id']) ?? 0;
    $quantity = intval($_POST['quantity']);

    $product_service = new ProductService();

    try {
        $product_service->addToCart($product_id, $quantity, $variation_id);
        wp_send_json_success();
    } catch (WP_Exception $e) {
        wp_send_json_error($e->getMessage(), 406);
    }
}

add_action('wp_ajax_ajax_add_to_cart', 'ajax_add_to_cart');
add_action('wp_ajax_nopriv_ajax_add_to_cart', 'ajax_add_to_cart');

function ajax_remove_from_cart(): void
{
    if (!check_ajax_referer('ajax_remove_from_cart_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $item_key = $_POST['item_key'];

    $product_service = new ProductService();

    try {
        $product_service->removeFromCart($item_key);
        wp_send_json_success();
    } catch (WP_Exception $e) {
        wp_send_json_error($e->getMessage(), 406);
    }
}

add_action('wp_ajax_ajax_remove_from_cart', 'ajax_remove_from_cart');
add_action('wp_ajax_nopriv_ajax_remove_from_cart', 'ajax_remove_from_cart');


function ajax_update_cart_quantity(): void
{
    if (!check_ajax_referer('ajax_update_cart_quantity_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $item_key = $_POST['item_key'];
    $quantity = intval($_POST['quantity']);

    $product_service = new ProductService();

    try {
        $product_service->updateCartQuantity($item_key, $quantity);
        wp_send_json_success();
    } catch (WP_Exception $e) {
        wp_send_json_error($e->getMessage(), 406);
    }
}

add_action('wp_ajax_ajax_update_cart_quantity', 'ajax_update_cart_quantity');
add_action('wp_ajax_nopriv_ajax_update_cart_quantity', 'ajax_update_cart_quantity');

function ajax_update_cart_customer_info(): void
{
    if (!check_ajax_referer('ajax_update_cart_customer_info_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $product_service = new ProductService();
    $product_service->updateCartCustomerInfo($_POST);
    wp_send_json_success();
}

add_action('wp_ajax_ajax_update_cart_customer_info', 'ajax_update_cart_customer_info');
add_action('wp_ajax_nopriv_ajax_update_cart_customer_info', 'ajax_update_cart_customer_info');

function ajax_apply_coupon(): void
{
    if (!check_ajax_referer('ajax_apply_coupon_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $coupon_code = $_POST['coupon_code'];

    $product_service = new ProductService();

    try {
        $product_service->applyCoupon($coupon_code);
        wp_send_json_success();
    } catch (WP_Exception $e) {
        wp_send_json_error($e->getMessage(), 406);
    }
}

add_action('wp_ajax_ajax_apply_coupon', 'ajax_apply_coupon');
add_action('wp_ajax_nopriv_ajax_apply_coupon', 'ajax_apply_coupon');

function ajax_remove_coupon(): void
{
    if (!check_ajax_referer('ajax_remove_coupon_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $coupon_code = $_POST['coupon_code'];

    $product_service = new ProductService();

    try {
        $product_service->removeCoupon($coupon_code);
        wp_send_json_success();
    } catch (WP_Exception $e) {
        wp_send_json_error($e->getMessage(), 406);
    }
}

add_action('wp_ajax_ajax_remove_coupon', 'ajax_remove_coupon');
add_action('wp_ajax_nopriv_ajax_remove_coupon', 'ajax_remove_coupon');


function ajax_login(): void
{
    if (!check_ajax_referer('ajax_login_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $username = $_POST['username'];
    $password = intval($_POST['password']);

    $general_service = new GeneralService();

    try {
        $general_service->login($username, $password);
        wp_send_json_success();
    } catch (WP_Exception $e) {
        wp_send_json_error($e->getMessage(), 406);
    }
}

add_action('wp_ajax_ajax_login', 'ajax_login');
add_action('wp_ajax_nopriv_ajax_login', 'ajax_login');

function ajax_login_otp(): void
{
    if (!check_ajax_referer('ajax_login_otp_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $mobile = $_POST['mobile'];
    $code = intval($_POST['code']);

    $general_service = new GeneralService();

    try {
        $general_service->loginOtp($mobile, $code);
        wp_send_json_success();
    } catch (WP_Exception $e) {
        wp_send_json_error($e->getMessage(), 406);
    }
}

add_action('wp_ajax_ajax_login_otp', 'ajax_login_otp');
add_action('wp_ajax_nopriv_ajax_login_otp', 'ajax_login_otp');


function ajax_send_otp(): void
{
    if (!check_ajax_referer('ajax_send_otp_nonce', 'security', false)) {
        wp_send_json_error('Invalid security token.', 403);
    }

    $mobile = $_POST['mobile'] ?? '';

    $general_service = new GeneralService();

    try {
        $general_service->sendOtp($mobile);
        wp_send_json_success();
    } catch (WP_Exception $e) {
        wp_send_json_error($e->getMessage(), 406);
    }
}

add_action('wp_ajax_ajax_send_otp', 'ajax_send_otp');
add_action('wp_ajax_nopriv_ajax_send_otp', 'ajax_send_otp');