<?php

use Services\enums\SliderType;
use Services\GeneralService;

$general_service = new GeneralService();
$posts = $general_service->getBlogPosts(7)["posts"];
?>

<?php if (empty($posts)) {
    return;
}
?>

<div class="mt-15 container-md">
    <div class="flex flex-row px-5 py-4">
        <div class="flex-1 flex flex-row items-center gap-x-4 text-h3">
            <span class="text-primary"><?= get_icon("newspaper-fill", IconSize::Large) ?></span>
            <span>بلاگ</span>
        </div>
        <a class="text-body-s text-primary" href="<?= get_post_type_archive_link('post') ?>">
            مشاهده بیشتر
        </a>
    </div>
    <div class="grid grid-cols-1 lg:grid-cols-3 grid-flow-row lg:grid-flow-col gap-x-6 gap-y-3 lg:gap-y-2">
        <?php for ($i = 0; $i < sizeof($posts); $i++) { ?>
            <?php $post = $posts[$i]; ?>
            <?php if ($i !== 3) { ?>
                <div class="col-span-1 row-span-1">
                    <?php get_template_part('parts/post-card-2/post-card-2', null, ['post' => $post]); ?>
                </div>
            <?php } else { ?>
                <div class="col-span-1 row-span-3 h-full">
                    <?php get_template_part('parts/post-card-1/post-card-1', null, ['post' => $post]); ?>
                </div>
            <?php } ?>
        <?php } ?>
    </div>
</div>