<?php

use Services\enums\SliderType;
use Services\GeneralService;

$general_service = new GeneralService();
$brands = $general_service->getBrandSlider(SliderType::HomeSliderBrand);
?>

<div class="mt-15 container-md">
    <div class="overflow-hidden relative group" data-type="swiper" data-loop="true" data-play="true" data-size="brand">
        <div class="absolute flex flex-row w-40 h-full z-10 bg-gradient-to-l from-bg to-bg/0 top-0 start-0 items-center has-[.swiper-button-lock]:hidden">
            <button class="hidden group-hover:inline p-2 rounded-full bg-white border border-border
             cursor-pointer transition-colors hover:bg-neutral-100"
                    data-type="swiper-prev">
                <?= get_icon("caret-right") ?>
            </button>
        </div>
        <div class="absolute flex flex-row-reverse w-40 h-full z-10 bg-gradient-to-r from-bg to-bg/0 top-0 end-0 items-center has-[.swiper-button-lock]:hidden">
            <button class="hidden group-hover:inline p-2 rounded-full bg-white border border-border
             cursor-pointer transition-colors hover:bg-neutral-100"
                    data-type="swiper-next">
                <?= get_icon("caret-left") ?>
            </button>
        </div>

        <div class="w-full">
            <div class="swiper">
                <div class="swiper-wrapper">
                    <?php foreach ($brands as $brand) { ?>
                        <div class="swiper-slide">
                            <div class="h-full p-2 flex items-center">
                                <img class="w-full" src="<?= $brand->src ?>" alt="<?= $brand->alt ?>"/>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>