<?php

use Services\enums\SliderType;
use Services\GeneralService;

$general_service = new GeneralService();
$breadcrumb = $general_service->getBreadcrumb();

if (empty($breadcrumb))
    return;

?>

<nav aria-label="breadcrumb">
    <ol class="flex flex-row items-center">
        <?php for ($i = 0; $i < sizeof($breadcrumb); $i++) { ?>
            <?php $item = $breadcrumb[$i]; ?>
            <?php if ($i + 1 != sizeof($breadcrumb)) { ?>
                <li>
                    <a class="text-detail" href="<?= $item->url ?>" target="<?= $item->target ?>">
                        <?= $item->title ?>
                    </a>
                    <span class="text-detail">&nbsp; / &nbsp;</span>
                </li>
            <?php } else { ?>
                <li>
                    <span class="text-detail">
                        <?= $item->title ?>
                    </span>
                </li>
            <?php } ?>
        <?php } ?>
    </ol>
</nav>