<?php

use Services\enums\SliderType;
use Services\GeneralService;
use Services\ProductService;

$gateways = WC()->payment_gateways()->get_available_payment_gateways();
$coupons = WC()->cart->get_applied_coupons();
$coupon = empty($coupons) ? null : $coupons[0];
?>

<div class="grid grid-cols-12 gap-x-4 gap-y-6 px-4 py-6 bg-bg rounded-2xl">
    <div class="col-span-12 flex flex-col">
        <div class="text-body-s">ثبت کد تخفیف</div>
        <label class="w-full relative mt-4 group/coupon" data-type="checkout-coupon" data-loading="false"
               data-apply="<?= empty($coupon) ? 'false' : 'true' ?>">
            <input class="w-full text-body-s py-2 ps-4 pe-18 border border-border rounded-lg"
                   type="text" name="coupon_code" value="<?= $coupon ?>" <?= empty($coupon) ? '' : 'readonly' ?> />
            <button class="group-data-[apply=true]/coupon:hidden btn-primary absolute left-2 top-1/2 -translate-y-1/2 text-body-s py-0.5 items-center"
                    type="button" data-type="checkout-coupon-button-apply">
                <span class="group-data-[loading=false]/coupon:hidden animate-spin w-fit h-fit">
                    <?= get_icon("spinner-gap") ?>
                </span>
                ثبت
            </button>
            <button class="group-data-[apply=false]/coupon:hidden absolute left-2 top-1/2 -translate-y-1/2 flex flex-row items-center gap-x-2 p-2 text-red-500 text-body-s transition hover:text-red-800 hover:animate-wiggle cursor-pointer"
                    type="button" data-type="checkout-coupon-button-remove" data-loading="false">
                <span class="group-data-[loading=false]/coupon:hidden animate-spin w-fit h-fit">
                    <?= get_icon("spinner-gap") ?>
                </span>
                <span><?= get_icon("trash", IconSize::Large) ?></span>
            </button>
        </label>
        <div class="flex flex-row items-center gap-x-1 group/message" data-type="checkout-coupon-message-box"
             data-error="false">
            <span class="group-data-[error=false]/message:hidden text-red-500">
                <?= get_icon("warning-octagon-fill", IconSize::Small) ?>
            </span>
            <span class="text-body-s text-green-500 group-data-[error=true]/message:text-red-500"
                  data-type="checkout-coupon-message">
            </span>
        </div>
    </div>
    <div class="col-span-12 grid grid-cols-12 gap-x-4 gap-y-4">
        <span class="col-span-12 text-body-s">انتخاب درگاه پرداخت</span>
        <?php if (empty($gateways)) { ?>
            <span class="col-span-12 text-body-s">هیچ درگاه پرداختی توسط مدیریت فعال نشده است.</span>
        <?php } ?>
        <?php foreach ($gateways as $index => $gateway) { ?>
            <label class="col-span-12 sm:col-span-6 rounded-lg border border-border flex flex-row gap-x-4 p-4 transition has-checked:bg-neutral-50 hover:bg-neutral-100 items-center cursor-pointer">
                <span class="flex-shrink-0"><?= $gateway->get_icon() ?></span>
                <span class="text-body-s grow"><?= $gateway->get_title() ?></span>
                <input class="sr-only peer" type="radio" name="payment_method" value="<?= $index ?>"/>
                <span class="w-5 h-5 border border-border rounded-full flex items-center justify-center transition-all peer-checked:border-primary group/radio">
                    <span class="w-2.5 h-2.5 bg-primary rounded-full block scale-0 transition-transform group-peer-checked/radio:scale-100"></span>
                </span>
            </label>
        <?php } ?>
    </div>
</div>