<?php

use Services\enums\SliderType;
use Services\GeneralService;
use Services\ProductService;

$product_service = new ProductService();
$cart = $product_service->getCart();
$fields = WC()->checkout()->get_checkout_fields()["billing"];
$provinces = WC()->countries->get_states(wc()->countries->get_base_country());
?>

<div class="grid grid-cols-12 gap-x-4 gap-y-6 px-4 py-6 bg-bg rounded-2xl">
    <?php foreach ($fields as $key => $field) { ?>
        <?php $required = $field["required"]; ?>
        <?php $class = $field["class"][0]; ?>
        <?php $type = $field["type"] ?? "text"; ?>

        <div class="<?= $class ?>">
            <?php if ($type == "textarea") { ?>
                <?= get_textarea($field['label'], $key, 2, $required) ?>
            <?php } else if ($type == "state") { ?>
                <?= get_selector($field['label'], $key, $provinces, "province-selector", $required) ?>
            <?php } else if ($type == "billing_iran_cities") { ?>
                <?= get_selector($field['label'], $key, [], "city-selector", $required) ?>
            <?php } else if ($type == "number") { ?>
                <?= get_input($field['label'], $key, "number", $required) ?>
            <?php } else if ($type == "email") { ?>
                <?= get_input($field['label'], $key, "email", $required) ?>
            <?php } else { ?>
                <?= get_input($field['label'], $key, 'text', $required) ?>
            <?php } ?>
        </div>

    <?php } ?>
</div>