<?php

use Services\enums\SortType;
use Services\ProductService;

$product_service = new ProductService();
$cart = $product_service->getCart();
$products = $cart->products;
?>

<div class="flex flex-col gap-y-1" data-type="mini-cart-2">
    <?php foreach ($cart->products as $cart_product) { ?>
        <?php $product = $cart_product->product ?>
        <div class="flex overflow-hidden first:rounded-t-2xl last:rounded-b-2xl">
            <div class="w-full flex flex-row items-center bg-white rounded-sm overflow-hidden p-4 max-lg:flex-col max-lg:items-start">
                <div class="grow flex flex-row gap-x-6">
                    <a class="w-(--product-md-width) h-(--product-md-height) max-lg:w-(--product-s-width) max-lg:h-(--product-s-height) rounded-xl overflow-hidden"
                       href="<?= $product->link ?>">
                        <?= product_image($product->image) ?>
                    </a>
                    <a class="grow flex flex-col" href="<?= $product->link ?>">
                        <span class="text-detail w-full truncate"><?= $product->category ?></span>
                        <p class="text-body-s w-full line-clamp-3">
                            <?= $product->title ?>
                        </p>
                    </a>
                </div>

                <div class="flex flex-col gap-y-4 max-lg:flex-row max-lg:justify-between max-lg:w-full max-lg:items-center">
                    <form class="relative group/update-cart" data-loading="false" data-type="update-cart-quantity">
                        <span class="absolute hidden group-data-[loading=true]/update-cart:flex animate-pulse top-0 right-0 w-full h-full rounded-md bg-neutral-50"></span>
                        <input name="product_id" value="<?= $product->id ?>" type="hidden">
                        <input name="item_key" value="<?= $cart_product->item_key ?>" type="hidden">
                        <div class="flex flex-row gap-x-1" data-type="quantity"
                             data-min="<?= $product->min_quantity ?>" data-max="<?= $product->max_quantity ?>">
                            <div class="flex flex-row items-center px-1 py-0.5 border border-border gap-x-2 text-body rounded-md">
                                <button class="cursor-pointer p-1" data-type="quantity-plus">
                                    <?= get_icon('plus', IconSize::Small) ?>
                                </button>
                                <input name="quantity" class="w-4 text-center cursor-default"
                                       value="<?= $cart_product->quantity ?>"
                                       data-type="quantity-input" readonly/>
                                <button class="cursor-pointer p-1" data-type="quantity-minus">
                                    <?= get_icon('minus', IconSize::Small) ?>
                                </button>
                            </div>

                            <button data-type="quantity-remove" class="flex border border-border rounded-md">
                        <span class="p-2 text-red-500 transition hover:text-red-800 hover:animate-wiggle cursor-pointer">
                            <?= get_icon("trash-simple", IconSize::Large) ?>
                        </span>
                            </button>
                        </div>
                    </form>

                    <div class="grow flex flex-col gap-2 items-end">
                        <?php if ($product->discount > 0) { ?>
                            <div class="flex flex-row items-center gap-x-1">
                        <span class="text-detail px-2 bg-red-500 text-white rounded-full self-start">
                            <?= $product->discount ?>%
                        </span>
                                <span class="text-detail text-fg-2 line-through leading-none text-left">
                            <?= format_price($product->regular_price) ?> تومانء
                        </span>
                            </div>
                        <?php } ?>
                        <span class="text-body leading-none text-left">
                                <?= format_price($product->sale_price) ?> تومانء
                            </span>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
</div>