<?php

use Services\enums\SortType;
use Services\ProductService;

$product_service = new ProductService();
$cart = $product_service->getCart();
?>

<div data-type="mini-cart">
    <div class="h-full group relative" data-type="hover" data-active="false" data-overlay-z="30">
        <div class="h-full text-primary text-body-s py-1 px-1 rounded border-solid border border-border flex items-center cursor-pointer">
            <?= get_icon('shopping-bag', IconSize::Large) ?>
        </div>

        <span class="data-[active='false']:hidden absolute w-5 h-5 text-detail bg-primary text-primary-fg-1 text-center content-center leading-0 -top-1 -right-1 rounded-full"
              data-type="cart-quantity" data-active="false">
        </span>

        <div class="group-data-[active=false]:hidden relative animate-dropdown">
            <div class="p-4 z-10 absolute top-full lg:-translate-x-1/2 lg:left-[clamp(0px,calc(90rem-100dvw),7rem)] max-lg:-left-15">
                <div class="flex flex-col gap-y-4 bg-bg rounded-2xl p-4 shadow-sm w-(--mini-cart-width) h-(--mini-cart-height)">
                    <?php if (empty($cart->products)) { ?>
                        <div class="flex flex-col gap-y-4 grow justify-center">
                            <span class="text-6xl text-neutral-200 self-center"><?= get_icon("basket-fill", IconSize::Large) ?></span>
                            <p class="text-center text-body-s">سبد خرید شما خالی است.</p>
                            <a class="text-detail text-primary flex flex-row gap-x-1 items-center self-center"
                               href="<?= wc_get_page_permalink('shop') . "?sort=" . SortType::Popularity->value ?>">
                                برو به پرفروش‌ترین‌ها
                                <?= get_icon('caret-left') ?>
                            </a>
                        </div>
                    <?php } else { ?>
                        <div class="flex flex-col grow overflow-y-auto overflow-x-hidden">
                            <?php foreach ($cart->products as $cart_product) { ?>
                                <div class="flex flex-row items-center gap-x-4 border-b border-border">
                                    <a class="min-w-(--product-s-width) w-(--product-s-width) h-(--product-s-height) rounded-lg overflow-hidden flex"
                                       href="<?= $cart_product->product->link ?>">
                                        <?php if (!empty($cart_product->product->image)) { ?>
                                            <img src="<?= $cart_product->product->image->src ?>"
                                                 alt="<?= $cart_product->product->image->alt ?>"
                                            />
                                        <?php } ?>
                                    </a>

                                    <div class="grow flex flex-col">
                                        <div class="flex flex-row gap-x-2 items-center justify-between">
                                            <a href="<?= $cart_product->product->link ?>">
                                                <h4 class="text-body-s line-clamp-1"><?= $cart_product->product->title ?></h4>
                                            </a>
                                            <form class="group/remove-cart" data-type="remove-from-cart"
                                                  data-loading="false">
                                                <input type="hidden" name="product_id"
                                                       value="<?= $cart_product->product->id; ?>">
                                                <input type="hidden" name="quantity"
                                                       value="<?= $cart_product->quantity; ?>">
                                                <input type="hidden" name="item_key"
                                                       value="<?= $cart_product->item_key; ?>">
                                                <button type="submit"
                                                        class="flex flex-row items-center gap-x-2 p-2 text-red-500 text-body-s transition hover:text-red-800 hover:animate-wiggle cursor-pointer">
                                            <span class="group-data-[loading=false]/remove-cart:hidden animate-spin w-fit h-full">
                                                <?= get_icon("spinner-gap") ?>
                                            </span>
                                                    <?= get_icon("trash", IconSize::Large) ?>
                                                </button>
                                            </form>
                                        </div>

                                        <div class="flex flex-row gap-x-2 justify-between">
                                            <div class="text-detail">
                                                <span><?= $cart_product->quantity ?></span>
                                                ×
                                                <span><?= format_price($cart_product->product->sale_price) ?></span>
                                                تومانء
                                            </div>

                                            <div class="text-detail font-bold">
                                                <span><?= format_price($cart_product->quantity * $cart_product->product->sale_price) ?></span>
                                                تومانء
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>

                        <a class="text-body-s btn-primary w-fit rounded-lg self-end"
                           href="<?= wc_get_page_permalink('cart') ?>">
                            رفتن به سبد خرید
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>