<?php

use Services\enums\SliderType;
use Services\GeneralService;
use Services\ProductService;

/* @var array{page: string} $args */
$page = $args['page']; // cart | checkout

$product_service = new ProductService();
$cart = $product_service->getCart();

$general_service = new GeneralService();
$phone_number = $general_service->getPhoneNumber(SliderType::PhoneNumberSupport);

$shipping_enabled = get_option('woocommerce_ship_to_countries') !== 'disabled';
$shipping_methods = WC()->shipping()->get_shipping_methods();
$selected_shipping_method = WC()->session->get('chosen_shipping_methods')[0] ?? null;
if (sizeof($shipping_methods) === 1) $selected_shipping_method = 0;
?>

<div class="flex flex-col p-1 bg-primary-light rounded-3xl" data-type="cart-widget-<?= $page ?>" data-loading="false">
    <div class="flex flex-row text-body gap-x-4 items-center py-3 px-4">
                            <span class="text-primary">
                                <?= get_icon("credit-card-fill", IconSize::Large) ?>
                            </span>
        <span>پرداخت و ثبت سفارش</span>
    </div>

    <div class="flex flex-col bg-bg p-6 gap-y-6 rounded-2xl shadow-sm">
        <div class="flex flex-col">
            <div class="flex flex-row justify-between text-body-s">
                <span>مجموع قیمت کالاها:</span>
                <span><?= format_price($cart->subtotal) ?> تومانء</span>
            </div>
            <?php if (!empty($cart->discountTotal)) { ?>
                <div class="flex flex-row justify-between text-body-s">
                    <span>کل تخفیف شما:</span>
                    <span class="text-red-500"><?= format_price($cart->discountTotal) ?> تومانء</span>
                </div>
            <?php } ?>
            <?php if (!empty($cart->shippingTotal)) { ?>
                <div class="flex flex-row justify-between text-body-s">
                    <span>هزینه ارسال:</span>
                    <span><?= format_price($cart->shippingTotal) ?> تومانء</span>
                </div>
            <?php } ?>
            <?php if (!empty($cart->feeTotal)) { ?>
                <div class="flex flex-row justify-between text-body-s">
                    <span>سایر:</span>
                    <span><?= format_price($cart->feeTotal) ?> تومانء</span>
                </div>
            <?php } ?>
            <div class="flex flex-row justify-between text-body-s">
                <span>مجموع قابل پرداخت:</span>
                <span class="text-body text-primary"><?= format_price($cart->grandTotal) ?> تومانء</span>
            </div>

            <?php if ($page === "checkout") { ?>
                <?php if ($shipping_enabled && empty($shipping_methods)) { ?>
                    <span class="text-red-500 text-body-s">هیچ روش ارسالی برای سبد خرید شما یافت نشد. شهر را تغییر دهید.</span>
                <?php } else if ($shipping_enabled) { ?>
                    <?php if (sizeof($shipping_methods) === 1) { ?>
                        <input class="sr-only" name="shipping_method[0]" value="<?= $shipping_methods[0]->id ?>" form="checkout-form"/>
                    <?php } else { ?>
                        <?= get_shipping_method_selector($shipping_methods) ?>
                    <?php } ?>
                    <?php if ($selected_shipping_method != null) { ?>
                        <span class="text-body-s empty:hidden"><?= $shipping_methods[$selected_shipping_method]->description ?></span>
                        <span class="text-body-s empty:hidden"><?= $shipping_methods[$selected_shipping_method]->delivery_time ?></span>
                    <?php } ?>
                <?php } ?>
            <?php } ?>
        </div>

        <?php if ($page == 'cart') { ?>
            <a class="btn-primary text-body-s" href="<?= wc_get_page_permalink('checkout') ?>">
                <?= get_icon("credit-card", IconSize::Large) ?>
                ادامه فرآیند خرید
            </a>
        <?php } else { ?>
            <button class="btn-primary text-body-s group/button data-[active='false']:btn-disabled"
                    form="checkout-form" data-type="checkout-button" data-loading="false"
                    data-active="<?= $shipping_enabled && empty($shipping_methods) ? "false" : "true" ?>">
                <span class="group-data-[loading=false]/button:hidden animate-spin w-fit h-full">
                    <?= get_icon("spinner-gap") ?>
                </span>
                <?= get_icon("credit-card", IconSize::Large) ?>
                پرداخت و ثبت سفارش
            </button>
        <?php } ?>
    </div>

    <div class="flex flex-col py-2 px-4 gap-y-2">
        <span class="text-body font-bold">نکات قبل از پرداخت:</span>
        <div class="flex flex-row gap-x-2 text-body-s items-start">
            <span class="py-0.5"><?= get_icon("warning-octagon", IconSize::Large) ?></span>
            <p>قبل از پرداخت حتماً فیلترشکن خود را خاموش کنید!</p>
        </div>
        <div class="flex flex-row gap-x-2 text-body-s items-start">
            <span class="py-0.5"><?= get_icon("headset", IconSize::Large) ?></span>
            <p>
                در صورتی که پول از حساب شما کسر شد ولی سفارش ثبت نشد تا ۷۲ ساعت صبر کنید. در غیر
                اینصورت با شماره
                <?= $phone_number ?>
                تماس بگیرید.
            </p>
        </div>
    </div>
</div>