<?php

use Services\enums\SliderType;
use Services\GeneralService;

$general_service = new GeneralService();
$categories = $general_service->getCategorySlider(SliderType::HomeCategory);
?>

<div class="mt-6 lg:-mt-6 container-lg">
    <div class="p-1 bg-primary-light rounded-3xl relative z-10" data-type="swiper" data-size="category">
        <div class="flex flex-row text-h3 px-4 py-3">
            <div class="flex-1 flex flex-row items-center gap-x-4">
                <span class="text-primary"><?= get_icon("squares-four-fill", IconSize::Large) ?></span>
                <span>دسته‌بندی‌ها</span>
            </div>
            <div class="flex flex-row-reverse gap-x-1">
                <button class="p-1 cursor-pointer transition-colors text-primary hover:text-primary-dark aria-[disabled=true]:text-neutral-400"
                        data-type="swiper-next">
                    <?= get_icon("caret-left-fill") ?>
                </button>
                <button class="p-1 cursor-pointer transition-colors text-primary hover:text-primary-dark aria-[disabled=true]:text-neutral-400"
                        data-type="swiper-prev">
                    <?= get_icon("caret-right-fill") ?>
                </button>
            </div>
        </div>
        <div class="swiper rounded-2xl">
            <div class="swiper-wrapper">
                <?php foreach ($categories as $category) { ?>
                    <div class="swiper-slide overflow-hidden first:rounded-s-2xl last:rounded-e-2xl">
                        <a class="flex flex-col w-full items-center gap-y-4 p-8 bg-white rounded-sm"
                           href="<?= $category->link ?>">
                            <div class="flex w-(--category-l-width) h-(--category-l-height)">
                                <img class="w-full object-contain" src="<?= $category->image->src ?>"
                                     alt="<?= $category->image->alt ?>"/>
                            </div>
                            <span class="text-body w-full truncate text-center">
                            <?= $category->title ?>
                        </span>
                        </a>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>