<?php

use services\enums\PostType;

/* @var array{post_id: int, post_type: PostType} $args */
$post_id = $args["post_id"];
$post_type = $args["post_type"];

?>

<form class="flex flex-col gap-y-4 rounded-2xl bg-bg shadow-sm p-6 group"
      novalidate data-type="submit-comment" data-error="false" data-loading="false">
    <input type="hidden" name="post_id" value="<?= $post_id ?>"/>
    <input type="hidden" name="post_type" value="<?= $post_type->value ?>"/>
    <div class="flex flex-row justify-between p-4 items-center">
        <span class="text-h3">ثبت نظر</span>
        <span class="lg:hidden text-body p-1 rounded bg-neutral-50" data-type="dialog-close-comment-form">
            <?= get_icon("x") ?>
        </span>
    </div>

    <?php if ($post_type == PostType::Product) { ?>
        <div class="flex flex-row items-center">
        <span class="flex-1 text-body-s">
            به این
            <?= $post_type->get_display() ?>
            امتیاز بدید*
        </span>
            <span class="flex flex-row-reverse">
                                <?php for ($i = 5; $i > 0; $i--) { ?>
                                    <label class="peer group/star p-1/2 cursor-pointer">
                                        <input class="sr-only" type="radio" name="rate" value="<?= $i ?>"/>
                                        <span class="text-yellow-400 group-has-checked/star:hidden group-peer-has-checked/star:hidden group-hover/star:hidden group-peer-hover/star:hidden">
                                            <?= get_icon('star') ?>
                                        </span>
                                        <span class="text-yellow-400 hidden group-has-checked/star:block group-peer-has-checked/star:block peer-checked:block group-hover/star:block group-peer-hover/star:block">
                                            <?= get_icon('star-fill') ?>
                                        </span>
                                    </label>
                                <?php } ?>
                            </span>
        </div>
    <?php } ?>

    <label>
        <input class="text-body w-full rounded-lg px-3 py-2 border border-border group-data-[error=true]:data-[error=true]:outline group-data-[error=true]:data-[error=true]:outline-error"
               name="name" type="text" autocomplete="name" placeholder="نام*"
               data-type="input-required" data-error="false" data-message=""
        />
    </label>
    <label>
        <input class="text-body w-full rounded-lg px-3 py-2 border border-border group-data-[error=true]:data-[error=true]:outline group-data-[error=true]:data-[error=true]:outline-error"
               name="email" type="email" autocomplete="email" placeholder="ایمیل"
               data-type="input-email" data-error="false" data-message=""
        />
    </label>
    <label>
                        <textarea
                                class="text-body w-full rounded-lg px-3 py-2 border border-border group-data-[error=true]:data-[error=true]:outline group-data-[error=true]:data-[error=true]:outline-error"
                                rows=3 name="content" placeholder="دیدگاه شما*" value=""
                                data-type="input-required" data-error="false" data-message=""></textarea>
    </label>
    <div class="flex flex-row-reverse items-center">
        <button class="text-body-s px-4 bg-primary text-primary-fg-1 rounded-md cursor-pointer transition hover:bg-primary-dark flex flex-row gap-x-1 items-center">
                                <span class="group-data-[loading=false]:hidden animate-spin w-fit h-full">
                                    <?= get_icon("spinner-gap") ?>
                                </span>
            ثبت
        </button>
        <span class="flex-1 flex flex-row gap-x-1 items-center text-body-s text-error group-data-[error=false]:hidden">
                                <span><?= get_icon('warning-octagon-fill') ?></span>
                                <span data-type="submit-comment-error"></span>
                            </span>
    </div>
</form>