<?php

use Services\dtos\CommentDto;
use services\enums\PostType;
use Services\ProductService;

/* @var array{post_id: int, post_type: PostType, page_number: int} $args */
$post_id = $args['post_id'];
$post_type = $args['post_type'];
$page_number = $args['page_number'] ?? 1;

$page_size = 10;

$product_service = new ProductService();
$comment_result = $product_service->getComments($post_id, 5, $page_size, $page_number);
$comments = $comment_result['comments'];
$total = $comment_result['total'];
$total_pages = ceil($total / $page_size);

// Make comments appear only 2-levels
foreach ($comments as $comment) {
    $comment->children = extend_comment_children($comment);
}

function extend_comment_children(CommentDto $comment): array
{
    $comment->date = format_datetime($comment->date);
    $children = [];
    foreach ($comment->children as $child) {
        $children[] = $child;
        $successors = extend_comment_children($child);
        foreach ($successors as $successor) {
            $children[] = $successor;
        }
    }
    return $children;
}

?>

<div class="flex flex-col bg-primary-light p-1 rounded-3xl relative group"
     data-type="comments" data-post-id="<?= $post_id; ?>" data-loading="false">
    <div class="px-4 py-3">
        <div class="flex-1 flex flex-row items-center gap-x-4 text-h3">
            <span class="text-primary"><?= get_icon("chat-circle-text-fill", IconSize::Large) ?></span>
            <span class="grow">نظرات</span>
            <span class="text-detail btn-primary lg:hidden" data-type="dialog-activator-comment-form">
                <?= get_icon("pencil-simple-line", IconSize::Large) ?>
                ثبت نظر
            </span>
        </div>
    </div>
    <div class="flex flex-col gap-y-1 group-data-[loading=true]:hidden">
        <?php if (empty($comments)) { ?>
            <span class="p-4 bg-bg rounded-2xl text-detail">
                هیچ نظری ثبت نشده. اولین نفری باشید که به این محصول نظر میدهید.
            </span>
        <?php } ?>
        <?php foreach ($comments as $comment) { ?>
            <div class="p-4 bg-bg rounded-sm first:rounded-t-2xl last:rounded-b-2xl shadow-sm flex flex-col">
                <div class="flex flex-row items-center border-b border-border pb-2 mb-2">
                    <span class="flex-1 text-body-s font-medium data-[admin=true]:text-primary"
                          data-admin="<?= $comment->is_admin ? 'true' : 'false' ?>">
                        <?= $comment->user_name ?>
                    </span>
                    <span class="text-detail"><?= $comment->date ?></span>
                </div>

                <span class="text-body-s"> <?= $comment->content ?> </span>

                <div class="flex flex-col gap-y-1">
                    <?php foreach ($comment->children as $child) { ?>
                        <div class="p-4 bg-neutral-100 rounded-sm flex flex-col">
                            <div class="flex flex-row items-center border-b border-border pb-2 mb-2">
                                <span class="flex-1 text-body-s font-medium data-[admin=true]:text-primary"
                                      data-admin="<?= $child->is_admin ? 'true' : 'false' ?>">
                                    <?= $child->user_name ?>
                                </span>
                                <span class="text-detail"><?= $child->date ?></span>
                            </div>
                            <span class="text-body-s"> <?= $child->content ?> </span>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
    </div>

    <div class="flex flex-col gap-y-1 group-data-[loading=false]:hidden">
        <?php for($i = 1; $i <= $page_size; $i++) { ?>
        <div class="p-4 bg-bg rounded-sm first:rounded-t-2xl last:rounded-b-2xl shadow-sm flex flex-col">
            <div class="flex border-b border-border pb-2 mb-2 py-4">
                <span class="animate-pulse min-h-4 w-15 rounded-full bg-neutral-200"></span>
            </div>
            <div class="flex flex-col gap-y-4">
                <span class="animate-pulse min-h-3 w-50 rounded-full bg-neutral-200"></span>
                <span class="animate-pulse min-h-3 w-40 rounded-full bg-neutral-200"></span>
            </div>
        </div>
        <?php } ?>
    </div>

    <?php get_template_part("parts/pagination/pagination", null,
        ['page' => $page_number,'ajax' => true, 'total' => $total_pages, 'pagination_type' => 'comments']
    ); ?>
</div>