<?php

use Services\enums\SliderType;
use Services\ProductService;

$product_service = new ProductService();
$daily_special = $product_service->getDailySpecialProduct(SliderType::DailySpecialProduct);

if (empty($daily_special) || empty($daily_special['products']))
    return;
?>

<div class="mt-15 container-xl">
    <div class="relative overflow-hidden py-6 px-3 sm:rounded-2xl shadow-sm bg-gradient-to-l from-primary to-primary/70"
         data-type="swiper" data-size="special-offer">
        <button class="aria-[disabled=true]:hidden absolute right-4 top-1/2 -translate-y-1/2 p-3 rounded-full bg-white border border-border
             cursor-pointer transition-colors hover:bg-neutral-100 z-10"
                data-type="swiper-prev">
            <?= get_icon("caret-right") ?>
        </button>
        <button class="aria-[disabled=true]:hidden absolute left-4 top-1/2 -translate-y-1/2 p-3 rounded-full bg-white border border-border
             cursor-pointer transition-colors hover:bg-neutral-100 z-10"
                data-type="swiper-next">
            <?= get_icon("caret-left") ?>
        </button>
        <div class="swiper rounded-2xl">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <div class="flex flex-col h-full items-center justify-center text-primary-fg-1">
                        <span><?= get_icon("seal-percent-fill", IconSize::Large) ?></span>
                        <h2 class="text-h1 w-min break-words">حــــــراج ویـــــــژه روزانــــه</h2>
                        <!-- TODO -->
                    </div>
                </div>
                <?php foreach ($daily_special['products'] as $product) { ?>
                    <div class="swiper-slide overflow-hidden [&:nth-child(2)]:rounded-s-2xl last:rounded-e-2xl">
                        <?php get_template_part("parts/product-card/product-card", null, ['product' => $product]); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>