<?php

use Services\dtos\BannerDto;
use Services\dtos\FooterColumnDto;
use Services\enums\SliderType;
use Services\GeneralService;

$general_service = new GeneralService();

$logo = $general_service->getLogo();
$socials = $general_service->getSocialLinks(SliderType::FooterMainSocials);
$footer = $general_service->getFooterLinks(SliderType::FooterMainCols);

/* @var FooterColumnDto[] $columns */
$columns = [];
if(!empty($footer->column_one->links)) $columns[] = $footer->column_one;
if(!empty($footer->column_two->links)) $columns[] = $footer->column_two;
if(!empty($footer->column_three->links)) $columns[] = $footer->column_three;

$certificates = $footer->certificates;
?>

<footer>
    <div class="border-t border-border mt-9"></div>
    <div class="container-md mt-15 flex flex-col">
        <div class="flex flex-col gap-y-6">
            <div class="flex flex-row items-center">
                <div class="flex-1 h-(--logo-height) min-w-fit">
                    <img class="h-full" src="<?= $logo->src ?>" alt="<?= $logo->alt ?>"/>
                </div>
                <div class="flex flex-row-reverse gap-2 flex-wrap">
                    <?php foreach ($socials as $social) { ?>
                        <a class="p-2 border border-border text-primary text-h3 rounded-full transition hover:bg-neutral-100"
                           href="<?= $social->link ?>">
                            <?= get_icon($social->type->get_logo_name()) ?>
                        </a>
                    <?php } ?>
                </div>
            </div>
            <div class="grid grid-cols-12 gap-y-12 lg:gap-x-12">
                <div class="col-span-12 lg:col-span-9 flex flex-col md:flex-row gap-12">
                    <?php foreach ($columns as $column) { ?>
                        <div class="flex flex-col">
                            <span class="text-body-s mb-4 font-bold"><?= $column->title ?></span>
                            <?php foreach ($column->links as $link) { ?>
                                <a class="text-body-s flex text-balance"
                                   href="<?= $link->url ?>" target="<?= $link->target ?>">
                                    <?= $link->title ?>
                                </a>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
                <div class="col-span-12 lg:col-span-3 justify-center lg:justify-start flex flex-row-reverse flex-wrap gap-4 h-fit">
                    <?php foreach ($certificates as $certificate) { ?>
                        <a class="p-2 border border-border rounded-lg" href="<?= $certificate->link ?>"
                           target="_blank" referrerpolicy="origin">
                            <img class="h-(--footer-certificate-height) w-(--footer-certificate-width)" referrerpolicy="origin"
                                 src="<?= $certificate->image->src ?>" alt="<?= $certificate->image->alt ?>"/>
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="text-body-s py-6 border-t border-border text-center mt-6">
            تمامی حقوق متعلق به <?php echo get_bloginfo('name'); ?> است.
        </div>
    </div>
</footer>
