<?php

use Services\dtos\QaDto;

/* @var array{fqa_list: QaDto[] } $args */
$fqa_list = $args['fqa_list'];

?>

<?php if (empty($fqa_list)) {
    return;
}
?>

<div class="w-full flex flex-col bg-primary-light rounded-3xl">
    <div class="flex flex-row px-5 py-4 text-h3">
        <div class="flex-1 flex flex-row items-center gap-x-4">
            <span class="text-primary"><?= get_icon("chat-circle-text-fill", IconSize::Large) ?></span>
            <span>سؤالات متداول</span>
        </div>
    </div>
    <div class="flex flex-col gap-y-1 m-1">
        <?php foreach ($fqa_list as $fqa) { ?>
            <div class="bg-bg rounded-sm shadow-sm flex flex-col first:rounded-t-2xl last:rounded-b-2xl"
                 data-type="detail">
                <div class="px-16 pt-4 text-body cursor-pointer" data-type="detail-activator" data-active="false">
                    <?= $fqa->question ?>
                </div>
                <div class="px-16 pb-4 grid grid-rows-[0fr] transition-all data-[active=true]:grid-rows-[1fr]"
                     data-type="detail-content" data-active="false">
                    <div class="overflow-hidden">
                        <div class="text-body-s mt-2 pt-2 border-t border-t-border">
                            <?= $fqa->answer ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>