<?php

use Services\dtos\ImageDto;

/* @var array{images: ImageDto} $args */
$images = $args['images'];

?>

<div class="modal-md-square z-40 data-[active='false']:hidden animate-dropdown"
     data-type="dialog-content-gallery" data-active="false">
    <div class="bg-bg rounded-3xl w-full h-full m-auto relative overflow-hidden">
        <span class="absolute top-2 right-2 text-body p-2 cursor-pointer text-neutral-400 hover:text-fg transition"
              data-type="dialog-close-gallery">
            <?= get_icon("x") ?>
        </span>
        <div class="flex flex-col h-full pb-6 pt-12">
            <div class="overflow-hidden relative group" data-type="swiper" data-size="gallery-nav" data-id="gallery-nav">
                <div class="swiper">
                    <div class="swiper-wrapper">
                        <?php foreach ($images as $image) { ?>
                            <div class="swiper-slide px-2 overflow-hidden rounded-sm first:rounded-r-2xl last:rounded-l-2xl cursor-pointer">
                                <?= product_image($image) ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="overflow-hidden relative group justify-center flex-1" data-type="swiper" data-size="full" data-nav="gallery-nav">
                <button class="aria-[disabled=true]:hidden absolute right-4 top-1/2 -translate-y-1/2 p-3 rounded-full bg-white border border-border
             cursor-pointer transition-colors hover:bg-neutral-100 z-10 max-lg:hidden"
                        data-type="swiper-prev">
                    <?= get_icon("caret-right") ?>
                </button>
                <button class="aria-[disabled=true]:hidden absolute left-4 top-1/2 -translate-y-1/2 p-3 rounded-full bg-white border border-border
             cursor-pointer transition-colors hover:bg-neutral-100 z-10 max-lg:hidden"
                        data-type="swiper-next">
                    <?= get_icon("caret-left") ?>
                </button>
                <div class="swiper rounded-2xl h-full">
                    <div class="swiper-wrapper [&]:!h-full">
                        <?php foreach ($images as $image) { ?>
                            <div class="swiper-slide px-6 overflow-hidden rounded-sm first:rounded-r-2xl last:rounded-l-2xl [&>img]:h-full [&>img]:object-contain">
                                <?= product_image($image) ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>