<?php

use Services\GeneralService;
use Services\ProductService;

$general_service = new GeneralService();
$product_service = new ProductService();
// TODO
$is_login = is_user_logged_in();

$logo = $general_service->getLogo();
?>

<header xmlns="http://www.w3.org/1999/html">
    <div class="container-md relative z-30">
        <div class="bg-primary-light flex flex-col px-1 py-1 rounded-3xl mt-6">
            <div class="bg-bg shadow-sm rounded-2xl py-6 px-4 grid grid-cols-12 items-center gap-x-4 gap-y-5">
                <a href="/" class="w-fit col-span-3 max-lg:col-span-6 h-(--logo-height)">
                    <img class="h-full" src="<?= $logo->src ?>" alt="<?= $logo->alt ?>"/>
                </a>
                <div class="col-span-6 col-start-4 row-start-1 max-lg:col-span-12 max-lg:row-start-2">
                    <?php get_template_part("parts/searchbar/searchbar"); ?>
                </div>
                <div class="col-span-3 max-lg:col-span-6 justify-self-end flex flex-row gap-x-1">
                    <?php get_template_part("parts/cart-mini/cart-mini"); ?>
                    <?php if ($is_login) { ?>
                        <a href="<?= wc_get_page_permalink("myaccount") ?>"
                           class="h-full bg-primary text-white text-body-s py-1 px-1 rounded flex items-center cursor-pointer">
                            <?= get_icon('user', IconSize::Large) ?>
                        </a>
                    <?php } else { ?>
                        <button class="btn-primary text-body-s px-1 sm:px-4" data-type="dialog-activator-login"
                                data-overlay-z="40">
                            <?= get_icon('user', IconSize::Large) ?>
                            <span class="hidden sm:inline">ورود | ثبت‌نام</span>
                        </button>
                    <?php } ?>
                </div>
            </div>

            <div class="flex flex-row justify-between px-5 py-2">
                <div class="flex flex-row gap-x-6 justify-between grow sm:grow-0">
                    <div class="text-body-s cursor-pointer flex flex-row gap-x-2 items-center"
                         data-type="dialog-activator-megamenu" data-overlay-z="30" data-dialog-scroll="false">
                        <?= get_icon('list') ?>
                        <span>دسته بندی محصولات</span>

                        <?php get_template_part("parts/menu/menu"); ?>
                    </div>

                    <a class="text-body-s" href="<?= get_post_type_archive_link('post') ?>">بلاگ</a>
                </div>
                <div class="hidden sm:flex flex-row gap-x-6">
                    <a class="text-body-s" href="/contactus">تماس با ما</a>
                    <a class="text-body-s" href="/aboutus">درباره ما</a>
                </div>
            </div>
        </div>
    </div>
</header>
