<?php

use Services\enums\SliderType;
use Services\GeneralService;

$general_service = new GeneralService();
$hero_banner = wp_is_mobile() ? SliderType::HomeHeroMobile : SliderType::HomeHero;
$banners = $general_service->getSlider($hero_banner);

?>

<?php if (empty($banners)) { ?>
    <div class="min-h-15"></div>
    <?php return; ?>
<?php } ?>

<div class="mt-6">
    <div class="relative group" data-type="swiper" data-loop="true" data-size="full" data-free="false">
        <div class="absolute hidden group-hover:flex flex-row gap-x-2 bottom-10 right-10 z-10">
            <button class="p-3 rounded-full bg-white cursor-pointer transition-colors hover:bg-neutral-100"
                    data-type="swiper-prev">
                <?= get_icon("caret-right-fill") ?>
            </button>
            <button class="p-3 rounded-full bg-white cursor-pointer transition-colors hover:bg-neutral-100"
                    data-type="swiper-next">
                <?= get_icon("caret-left-fill") ?>
            </button>
        </div>
        <div class="swiper">
            <div class="swiper-wrapper">
                <?php foreach ($banners as $banner) { ?>
                    <a class="swiper-slide" href="<?= $banner->link ?>">
                        <img class="w-full" src="<?= $banner->image->src ?>" alt="<?= $banner->image->alt ?>"/>
                    </a>
                <?php } ?>
            </div>
        </div>
    </div>
</div>