<?php

use Services\enums\SliderType;
use Services\GeneralService;

$general_service = new GeneralService();
$sms_info = $general_service->getFarazSmsInfo(SliderType::FarazSmsInfo);
$otp_show = !empty($sms_info);
?>

<div class="modal-md z-40 data-[active='false']:hidden animate-dropdown" data-type="dialog-content-login"
     data-active="false">
    <div class="bg-bg rounded-3xl w-full h-full max-w-100 m-auto relative overflow-scroll scrollbar-hidden">
        <span class="absolute top-2 right-2 text-body p-2 cursor-pointer text-neutral-400 hover:text-fg transition"
              data-type="dialog-close-login">
            <?= get_icon("x") ?>
        </span>
        <div class="block p-6 pt-12">
            <form class="flex flex-col gap-y-2 group data-[active=false]:hidden"
                  data-type="login-form" data-loading="false" data-active="<?= $otp_show ? 'false' : 'true' ?>">
                <span class="text-h3 mb-4">ورود</span>
                <label class="flex flex-col text-body-s">
                    <span>نام کاربری</span>
                    <input class="border border-border py-1 px-4 rounded-md text-body" name="username"/>
                </label>
                <label class="flex flex-col text-body-s">
                    <span>رمزعبور</span>
                    <input class="border border-border py-1 px-4 rounded-md text-body" name="password" type="password"/>
                </label>
                <button class="text-body btn-primary mt-10" type="submit">
                    <span class="group-data-[loading=false]:hidden animate-spin w-fit h-full">
                        <?= get_icon("spinner-gap") ?>
                    </span>
                    ورود
                </button>

                <span class="text-detail text-primary self-center cursor-pointer mt-4 data-[active='false']:hidden"
                      data-type="send-otp-go" data-active="<?= $otp_show ? 'true' : 'false' ?>">
                    ورود با کد یکبار مصرف
                </span>
            </form>

            <form class="flex flex-col gap-y-2 group data-[active=false]:hidden"
                  data-type="send-otp-form" data-loading="false" data-active="<?= $otp_show ? 'true' : 'false' ?>">
                <span class="text-h3 mb-4">ورود با کد یکبار مصرف</span>
                <label class="flex flex-col text-body-s">
                    <span>شماره همراه</span>
                    <input class="border border-border py-1 px-4 rounded-md text-body" name="mobile" type="number"/>
                </label>
                <button class="text-body btn-primary mt-10" type="submit">
                    <span class="group-data-[loading=false]:hidden animate-spin w-fit h-full">
                        <?= get_icon("spinner-gap") ?>
                    </span>
                    ارسال کد
                </button>

                <span class="text-detail text-primary self-center cursor-pointer mt-4" data-type="login-go">
                    ورود با نام کاربری
                </span>
            </form>

            <form class="flex flex-col gap-y-2 group data-[active=false]:hidden"
                  data-type="login-otp-form" data-loading="false" data-active="false">
                <span class="text-h3 mb-4">ورود با کد یکبار مصرف</span>
                <label class="flex flex-col text-body-s" data-type="otp-box">
                    <span>کد</span>
                    <input type="hidden" name="code"/>
                    <span class="flex flex-row-reverse place-content-around">
                        <input class="w-15 text-center border border-border py-1 px-4 rounded-md text-body" type="number"/>
                        <input class="w-15 text-center border border-border py-1 px-4 rounded-md text-body" type="number"/>
                        <input class="w-15 text-center border border-border py-1 px-4 rounded-md text-body" type="number"/>
                        <input class="w-15 text-center border border-border py-1 px-4 rounded-md text-body" type="number"/>
                        <input class="w-15 text-center border border-border py-1 px-4 rounded-md text-body" type="number"/>
                    </span>
                </label>
                <button class="text-body btn-primary mt-10" type="submit">
                    <span class="group-data-[loading=false]:hidden animate-spin w-fit h-full">
                        <?= get_icon("spinner-gap") ?>
                    </span>
                    ورود
                </button>

                <div class="text-detail self-center">
                    فقط
                    <span class="w-10 inline-block text-center font-semibold" data-type="otp-timer"></span>
                    ثانیه فرصت داری
                </div>

                <span class="text-detail text-primary self-center cursor-pointer mt-4" data-type="login-go">
                    ورود با نام کاربری
                </span>
            </form>
        </div>
    </div>
</div>