<?php

use Services\GeneralService;

$general_service = new GeneralService();
$menu = $general_service->getMenu('primary');

?>

<div class="relative w-full">
    <div class="data-[active=false]:hidden bg-bg animate-megamenu rounded-2xl overflow-hidden absolute w-full top-6 start-0"
         data-type="dialog-content-megamenu" data-active="false">
        <div class="lg:hidden flex" data-type="menu-mobile">

            <div class="w-16 flex-shrink-0 border-l border-neutral-200 bg-neutral-100 overflow-y-auto">
                <ul>
                    <?php foreach ($menu as $index => $item_main) { ?>
                        <li>
                            <button type="button"
                                    class="w-full flex justify-center items-center h-16 transition-colors data-[active=true]:bg-white"
                                    data-mobile-tab-activator="<?= $item_main->id ?>"
                                    data-active="<?= $index === 0 ? 'true' : 'false' ?>">
                                <?php if ($item_main->icon) { ?>
                                    <?= create_icon($item_main->icon->svg_content, IconSize::Large) ?>
                                <?php } ?>
                            </button>
                        </li>
                    <?php } ?>
                </ul>
            </div>

            <div class="flex-1 relative overflow-hidden">
                <?php foreach ($menu as $index => $item1) { ?>
                    <div class="absolute inset-0 transition-opacity duration-200 data-[active=false]:opacity-0 data-[active=false]:pointer-events-none"
                         data-mobile-tab-content="<?= $item1->id ?>"
                         data-active="<?= $index === 0 ? 'true' : 'false' ?>">
                        <div class="relative w-full h-full" data-panel-container>
                            <div class="absolute inset-0 bg-white p-4 flex flex-col transition-transform duration-300 ease-in-out translate-x-0"
                                 data-panel="level-1">
                                <h3 class="text-lg font-bold border-b pb-3 mb-2"><?= $item1->title ?></h3>
                                <ul class="flex-1 overflow-y-auto">
                                    <li>
                                        <a href="<?= $item1->url ?>"
                                           class="flex items-center justify-between py-3 font-semibold text-primary">
                                            <span>همه‌ی محصولات <?= $item1->title ?></span>
                                            <?= get_icon('caret-left', IconSize::Small) ?>
                                        </a>
                                    </li>
                                    <?php foreach ($item1->children as $item2) { ?>
                                        <li>
                                            <a href="<?= empty($item2->children) ? $item2->url : '#' ?>"
                                               class="flex items-center justify-between py-3 border-b"
                                                    <?= !empty($item2->children) ? 'data-menu-target="panel-' . $item2->id . '"' : '' ?>>
                                                <span><?= $item2->title ?></span>
                                                <?php if (!empty($item2->children)) {
                                                    echo get_icon('caret-left', IconSize::Small);
                                                } ?>
                                            </a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>

                            <?php foreach ($item1->children as $item2) { ?>
                                <?php if (!empty($item2->children)) { ?>
                                    <div class="absolute inset-0 bg-white p-4 flex flex-col transition-transform duration-300 ease-in-out translate-x-full"
                                         id="panel-<?= $item2->id ?>" data-panel="level-2">
                                        <div class="flex items-center border-b pb-3 mb-2">
                                            <button type="button"
                                                    data-menu-back><?= get_icon('arrow-right') ?></button>
                                            <h4 class="text-lg font-bold text-center flex-1"><?= $item2->title ?></h4>
                                        </div>
                                        <ul class="flex-1 overflow-y-auto">
                                            <li>
                                                <a href="<?= $item2->url ?>"
                                                   class="flex items-center justify-between py-3 font-semibold text-primary">
                                                    <span>همه‌ی محصولات <?= $item2->title ?></span>
                                                    <?= get_icon('caret-left', IconSize::Small) ?>
                                                </a>
                                            </li>
                                            <?php foreach ($item2->children as $item3) { ?>
                                                <li>
                                                    <a href="<?= $item3->url ?>"
                                                       class="flex items-center justify-between py-3 border-b">
                                                        <span><?= $item3->title ?></span>
                                                    </a>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                        <div class="border-t pt-3 mt-auto">
                                            <a href="#" data-menu-back-to-root
                                               class="flex items-center justify-center gap-x-2 w-full text-primary font-semibold">
                                                <?= get_icon('arrow-right') ?>
                                                <span>بازگشت به دسته‌بندی‌ها</span>
                                            </a>
                                        </div>
                                    </div>
                                <?php } ?>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>