<?php

use Services\dtos\MenuItemDto;
use Services\GeneralService;

$general_service = new GeneralService();
$menu = $general_service->getMenu('primary');

/* @param MenuItemDto[] $menu */
function get_mobile_list(array $menu, MenuItemDto $parent = null, $depth = 0)
{
    $depth += 1;
    ?>
    <div class="absolute inset-0 flex flex-col bg-bg overflow-auto transition-all duration-1000 data-[state=invisible]:-translate-x-1/1 data-[state=invisible]:invisible data-[state=back]:invisible"
         data-state="invisible" data-type="menu-content-<?= $parent->id ?? 0 ?>" data-depth="<?= $depth ?>">
        <?php if (!empty($parent)) { ?>
            <a class="flex flex-row items-center gap-x-4 px-5 py-4 text-body" href="<?= $parent->url ?>">
                <?php if ($parent->icon) { ?>
                    <?= create_icon($parent->icon->svg_content, IconSize::Large) ?>
                <?php } ?>
                <span class="flex-1"><?= $parent->title ?></span>
                <?= get_icon('arrow-up-left') ?>
            </a>
        <?php } ?>

        <ul class="flex flex-col">
            <?php foreach ($menu as $item_main) { ?>
                <?php if (empty($item_main->children)) { ?>
                    <a class="flex flex-row items-center gap-x-4 px-5 py-4 text-body-s" href="<?= $item_main->url ?>">
                        <?php if ($item_main->icon) { ?>
                            <?= create_icon($item_main->icon->svg_content, IconSize::Large) ?>
                        <?php } ?>
                        <span class="flex-1"><?= $item_main->title ?></span>
                        <?= get_icon('arrow-up-left') ?>
                    </a>
                <?php } else { ?>
                    <li class="flex flex-row items-center gap-x-4 px-5 py-4 text-body-s"
                        data-type="menu-activator-<?= $item_main->id ?>">
                        <?php if ($item_main->icon) { ?>
                            <?= create_icon($item_main->icon->svg_content, IconSize::Large) ?>
                        <?php } ?>
                        <span class="flex-1"><?= $item_main->title ?></span>
                        <?= get_icon('caret-left', IconSize::Small) ?>
                    </li>
                <?php } ?>
            <?php } ?>
        </ul>
    </div>
    <?php
    foreach ($menu as $item_main) {
        get_mobile_list($item_main->children, $item_main, $depth);
    }
}

?>

<div class="absolute animate-megamenu top-45 [body.admin-bar_&]:top-53 bottom-4 right-1/2 translate-x-1/2 container-md hidden lg:block overflow-auto scrollbar-hidden inset-0 h-fit">
    <div class="bg-bg rounded-2xl overflow-hidden">
        <div class="grid grid-cols-4" data-type="menu">
            <div class="col-span-1 flex flex-col max-h-[77dvh] overflow-y-auto">
                <ul class="[direction:rtl]">
                    <?php foreach ($menu as $item_main) { ?>
                        <li class="text-body-s transition-colors data-[active='true']:text-primary data-[active='false']:bg-neutral-100
                        has-[+_[data-active='true']]:rounded-bl-2xl [&[data-active='true']_+_*]:rounded-tl-2xl"
                            data-type="menu-activator-<?= $item_main->id ?>" data-active="false">
                            <a class="flex flex-row items-center gap-x-4 px-5 py-4"
                               href="<?= $item_main->url ?>">
                                <?php if ($item_main->icon) { ?>
                                    <?= create_icon($item_main->icon->svg_content, IconSize::Large) ?>
                                <?php } ?>
                                <span class="flex-1"><?= $item_main->title ?></span>
                                <?= get_icon('caret-left', IconSize::Small) ?>
                            </a>
                        </li>
                    <?php } ?>
                </ul>
                <div class="flex-1 bg-neutral-100"></div>
            </div>
            <?php foreach ($menu as $item1) { ?>
                <div class="col-span-3 overflow-y-auto [direction:ltr] max-h-[77dvh] data-[active=false]:hidden"
                     data-type="menu-content-<?= $item1->id ?>" data-active="false">
                    <div class="columns-3 [direction:rtl] ">
                        <?php foreach ($item1->children as $item2) { ?>
                            <ul class="flex flex-col break-inside-avoid border-b border-border py-4">
                                <li class="flex text-body-s">
                                    <a class="flex flex-row gap-2 items-center transition-colors hover:text-primary w-full px-4"
                                       href="<?= $item2->url ?>">
                                        <span class="flex-1 font-medium"><?= $item2->title ?></span>
                                        <?= get_icon('arrow-up-left', IconSize::Small) ?>
                                    </a>
                                </li>
                                <?php foreach ($item2->children as $item3) { ?>
                                    <li class="flex text-body-s">
                                        <a class="flex transition-colors hover:text-primary w-full px-4"
                                           href="<?= $item3->url ?>">
                                            <span><?= $item3->title ?></span>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

<div class="animate-megamenu-mobile block lg:hidden">
    <div class="flex flex-col gap-y-4 bg-bg h-dvh" data-type="menu-mobile">
        <div class="flex flex-row justify-between p-4 items-center">
            <span class="text-body p-1 rounded bg-neutral-50 data-[active=false]:invisible"
                  data-type="menu-back" data-active="false">
                <?= get_icon("arrow-right") ?>
            </span>
            <span class="text-h3">دسته‌بندی‌ها</span>
            <span class="text-body p-1 rounded bg-neutral-50" data-type="dialog-close-megamenu">
                <?= get_icon("x") ?>
            </span>
        </div>

        <div class="relative grow">
            <?php get_mobile_list($menu); ?>
        </div>
    </div>
</div>