<?php

use Services\GeneralService;

$general_service = new GeneralService();
$menu = $general_service->getMenu('primary');

?>

<div class="relative w-full">
    <div class="data-[active=false]:hidden bg-bg animate-megamenu rounded-2xl overflow-hidden absolute w-full top-6 start-0"
         data-type="dialog-content-megamenu" data-active="false">
        <div class="grid grid-cols-4" data-type="menu">
            <div class="col-span-1 flex flex-col [direction:ltr] overflow-y-auto h-(--megamenu-height)">
                <ul class="[direction:rtl]">
                    <?php foreach ($menu as $item_main) { ?>
                        <li class="text-body-s transition-colors data-[active='true']:text-primary data-[active='false']:bg-neutral-100
                        has-[+_[data-active='true']]:rounded-bl-2xl [&[data-active='true']_+_*]:rounded-tl-2xl"
                            data-type="menu-activator-<?= $item_main->id ?>" data-active="false">
                            <a class="flex flex-row items-center gap-x-4 px-5 py-4"
                               href="<?= $item_main->url ?>">
                                <?php if ($item_main->icon) { ?>
                                    <?= create_icon($item_main->icon->svg_content, IconSize::Large) ?>
                                <?php } ?>
                                <span class="flex-1"><?= $item_main->title ?></span>
                                <?= get_icon('caret-left', IconSize::Small) ?>
                            </a>
                        </li>
                    <?php } ?>
                </ul>
                <div class="flex-1 bg-neutral-100"></div>
            </div>
            <?php foreach ($menu as $item1) { ?>
                <div class="col-span-3 overflow-y-auto [direction:ltr] h-(--megamenu-height) data-[active=false]:hidden"
                     data-type="menu-content-<?= $item1->id ?>" data-active="false">
                    <div class="columns-3 [direction:rtl] ">
                        <?php foreach ($item1->children as $item2) { ?>
                            <ul class="flex flex-col break-inside-avoid border-b border-border py-4">
                                <li class="flex text-body-s">
                                    <a class="flex flex-row gap-2 items-center transition-colors hover:text-primary w-full px-4"
                                       href="<?= $item2->url ?>">
                                        <span><?= $item2->title ?></span>
                                        <?= get_icon('caret-left', IconSize::Smaller) ?>
                                    </a>
                                </li>
                                <?php foreach ($item2->children as $item3) { ?>
                                    <li class="flex text-body-s">
                                        <a class="flex transition-colors hover:text-primary w-full px-4"
                                           href="<?= $item3->url ?>">
                                            <span><?= $item3->title ?></span>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>