<?php

use Services\dtos\FilterDto;

/* @var array{total: int, page_number: int, ajax: ?bool} $args */
$total = $args['total'];
$current_page = $args['page'];
$ajax = $args['ajax'] ?? false;
$pagination_type = 'pagination-' . ($args['pagination_type'] ?? '');
?>

<?php

/* @var array{page: ?int, content: string} $items */
$items = [];
if ($total > 1) {
    if ($current_page != 1) {
        $content = get_icon("arrow-right", IconSize::Large);
        $items[] = ['page' => $current_page - 1, 'content' => $content];
    }

    if ($current_page > 1) {
        $items[] = ['page' => 1, 'content' => '1'];
    }

    if ($current_page > 3) {
        $items[] = ['page' => null, 'content' => '...'];
    }

    if ($current_page > 2) {
        $items[] = ['page' => $current_page - 1, 'content' => strval($current_page - 1)];
    }

    $items[] = ['page' => $current_page, 'content' => strval($current_page)];

    if ($current_page < $total - 1) {
        $items[] = ['page' => $current_page + 1, 'content' => strval($current_page + 1)];
    }

    if ($current_page < $total - 2) {
        $items[] = ['page' => null, 'content' => '...'];
    }

    if ($current_page < $total) {
        $items[] = ['page' => $total, 'content' => strval($total)];
    }

    if ($current_page != $total) {
        $content = get_icon("arrow-left", IconSize::Large);
        $items[] = ['page' => $current_page + 1, 'content' => $content];
    }
}

?>

<?php if ($total < 2) return; ?>

<div class="flex flex-row p-3 self-center gap-x-4 max-w-full max-sm:gap-x-1 max-lg:gap-x-2">
    <?php foreach ($items as $item) { ?>
        <?php $link = empty($item['page']) ? '' : update_url(['page' => intval($item['page'])]); ?>
        <?php if ($item['page'] == $current_page) { ?>
            <span class="text-detail bg-bg rounded-sm h-10 w-10 inline-flex justify-center items-center text-primary">
                <?= $item['content'] ?>
            </span>
        <?php } else if (empty($link)) { ?>
            <span class="text-detail bg-bg rounded-sm h-10 w-10 inline-flex justify-center items-center">
                <?= $item['content'] ?>
            </span>
        <?php } else if ($ajax) { ?>
            <span class="text-detail cursor-pointer bg-bg rounded-sm transition hover:bg-neutral-100 h-10 w-10 inline-flex justify-center items-center"
                  data-type="<?= $pagination_type ?>" data-page="<?= $item['page'] ?>">
                <?= $item['content'] ?>
            </span>
        <?php } else { ?>
            <a class="text-detail cursor-pointer bg-bg rounded-sm transition hover:bg-neutral-100 h-10 w-10 inline-flex justify-center items-center"
               href="<?= $link ?>">
                <?= $item['content'] ?>
            </a>
        <?php } ?>
    <?php } ?>
</div>