<?php

use Services\dtos\PostDto;

/* @var array{post : PostDto , size : ?string} $args */
$post = $args['post'];
$size = $args['size'] ?? "md";

?>

<div class="h-full w-full rounded-3xl p-1 flex flex-col bg-primary-light">
    <a class="flex-1 flex flex-col rounded-2xl p-2 bg-bg shadow-sm"
       href="<?= $post->link ?>">
        <div class="w-full rounded-lg aspect-[2.3] overflow-hidden">
            <?php if (!empty($post->image)) { ?>
                <img class="w-full h-full object-cover" src="<?= $post->image->src ?>" alt="<?= $post->image->alt ?>"/>
            <?php } ?>
        </div>
        <div class="flex flex-col p-4">
            <span class="truncate text-body-s text-fg-2"><?= $post->category_name ?></span>
            <span class="text-body-s text-justify line-clamp-2 data-[size=lg]:line-clamp-1"
                  data-size="<?= $size ?>">
                <?= $post->title ?>
            </span>
            <span class="text-detail text-justify mt-2 line-clamp-7 data-[size=lg]:line-clamp-2"
                  data-size="<?= $size ?>">
                <?= $post->excerpt ?>
            </span>
        </div>
    </a>
    <div class="flex flx-row gap-x-1 text-primary text-detail p-1 self-center">
        <span><?= get_icon("calendar-dots") ?></span>
        <span><?= format_datetime($post->time, true) ?></span>
    </div>
</div>