<?php

use Services\dtos\PostDto;

/* @var PostDto $post */
$post = $args['post'];
?>

<div class="h-full w-full rounded-3xl p-1 flex flex-col bg-primary-light">
    <a class="flex-1 flex flex-row rounded-2xl bg-bg gap-x-3 p-2 shadow-sm"
       href="<?= $post->link ?>">
        <div class="overflow-hidden rounded-lg w-(--post-m-width) h-(--post-m-height)">
            <?php if (!empty($post->image)) { ?>
                <img class="w-full h-full object-cover" src="<?= $post->image->src ?>" alt="<?= $post->image->alt ?>"/>
            <?php } ?>
        </div>
        <div class="flex-1 flex flex-col px-3 overflow-hidden h-fit">
            <span class="w-full truncate text-body-s text-fg-2"><?= $post->category_name ?></span>
            <span class="flex-1 text-body-s text-justify line-clamp-2">
                <?= $post->title ?>
            </span>
        </div>
    </a>
    <div class="flex flx-row gap-x-1 text-primary text-detail p-1 self-center">
        <span><?= get_icon("calendar-dots", IconSize::Large) ?></span>
        <span><?= format_datetime($post->time, true) ?></span>
    </div>
</div>