<?php

use Services\dtos\PostDto;

/* @var PostDto $post */
$post = $args['post'];
?>

<div class="h-full w-full rounded-3xl p-1 flex flex-col bg-primary-light">
    <a class="flex-1 flex flex-row rounded-2xl bg-bg gap-x-3 p-4 shadow-sm items-center"
       href="<?= $post->link ?>">
        <span class="text-h3 text-primary"><?= get_icon("link-fill", IconSize::Large) ?></span>
        <div class="grow line-clamp-1">
            <span class="text-body-s text-primary">مقاله مرتبط:</span>
            <span class="text-body-s text-fg"><?= $post->title ?></span>
        </div>
        <span class="text-body text-primary"><?= get_icon("arrow-up-left") ?></span>
    </a>
    <div class="flex flx-row p-1 self-center">
        <a class="text-detail [direction:ltr]" href="<?= $post->link?>">
            <?= esc_url(urldecode($post->link)) ?>
        </a>
    </div>
</div>