<?php

use Services\dtos\PostDto;

/* @var PostDto $post */
$post = $args['post'];
?>

<div class="col-span-1 row-span-3 rounded-3xl p-1 flex flex-col bg-primary-light">
    <a class="flex-1 flex flex-col rounded-2xl p-2 overflow-hidden bg-bg shadow-sm"
       href="<?= $post->link ?>">
        <div class="w-full rounded-lg aspect-[2.3]">
            <?php if (!empty($post->image)) { ?>
                <img class="w-full h-full object-cover" src="<?= $post->image->src ?>" alt="<?= $post->image->alt ?>"/>
            <?php } ?>
        </div>
        <div class="flex flex-col p-4">
            <span class="truncate text-body-s text-fg-2"><?= $post->category_name ?></span>
            <span class="line-clamp-2 text-body-s text-justify"><?= $post->title ?></span>
            <span class="line-clamp-8 text-detail text-justify">
                <?= $post->excerpt ?>
            </span>
        </div>
    </a>
    <div class="flex flx-row gap-x-1 text-primary text-detail p-1 self-center">
        <span><?= get_icon("calendar-dots") ?></span>
        <span><?= $post->time ?></span>
    </div>
</div>