<?php

use Services\dtos\ProductDto;

/* @var ProductDto $product */
$product = $args['product'];
?>

<div class="flex flex-col w-full h-full items-center gap-y-4 p-4 bg-white rounded-sm shadow-sm">
    <a class="w-(--product-lg-width) h-(--product-lg-height) overflow-hidden rounded-xl" href="<?= $product->link ?>">
        <?= product_image($product->image) ?>
    </a>
    <a class="w-full flex flex-col" href="<?= $product->link ?>">
        <span class="text-detail w-full line-clamp-2 text-justify min-h-[calc(var(--text-detail)*var(--text-detail--line-height)*2)]">
            <?= $product->title ?>
        </span>
    </a>
    <div class="flex-1 flex flex-row-reverse items-center gap-x-1 w-full place-content-between">
        <div class="flex flex-col items-end">
            <?php if ($product->discount > 0) { ?>
                <span class="text-detail text-fg-2 line-through text-left">
                    <?= format_price($product->regular_price) ?> تومانء
                </span>
            <?php } ?>
            <span class="text-body-s text-left">
                <?= format_Price($product->sale_price) ?> تومانء
            </span>
        </div>
        <?php if ($product->discount > 0) { ?>
            <span class="text-body-s p-1 ps-2 bg-red-500 text-white rounded-full flex flex-row gap-x-1">
                ٪<?= $product->discount ?>
                <?= get_icon("seal-percent-fill", IconSize::Large) ?>
            </span>
        <?php } ?>
    </div>
</div>