<?php

use services\dtos\CartProductDto;

/* @var array{cart_product: CartProductDto} $args */
$cart_product = $args['cart_product'];
$product = $cart_product->product;
?>

<div class="w-full flex flex-row items-center bg-white rounded-sm overflow-hidden p-4">
    <a class="w-(--product-md-width) h-(--product-md-height) rounded-xl overflow-hidden" href="<?= $product->link ?>">
        <?= product_image($product->image) ?>
    </a>
    <div class="grow flex flex-row gap-x-6 ps-6 pe-2">
        <a class="grow flex flex-col" href="<?= $product->link ?>">
            <span class="text-detail w-full truncate"><?= $product->category ?></span>
            <p class="text-body-s w-full line-clamp-3 min-h-[calc(var(--text-body-s)*var(--text-body-s--line-height)*3)]">
                <?= $product->title ?>
            </p>
        </a>

        <div class="flex flex-col gap-y-4">
            <form data-loading="false" data-type="update-cart-quantity">
                <input name="product_id" value="<?= $product->id ?>" type="hidden">
                <input name="item_key" value="<?= $cart_product->item_key ?>" type="hidden">
                <div class="flex flex-row gap-x-1" data-type="quantity"
                     data-min="<?= $product->min_quantity ?>" data-max="<?= $product->max_quantity ?>">
                    <div class="flex flex-row items-center px-1 py-0.5 border border-border gap-x-2 text-body rounded-md">
                        <button class="cursor-pointer p-1" data-type="quantity-plus">
                            <?= get_icon('plus', IconSize::Small) ?>
                        </button>
                        <input name="quantity" class="w-4 text-center cursor-default"
                               value="<?= $cart_product->quantity ?>"
                               data-type="quantity-input" readonly/>
                        <button class="cursor-pointer p-1" data-type="quantity-minus">
                            <?= get_icon('minus', IconSize::Small) ?>
                        </button>
                    </div>

                    <button data-type="quantity-remove" class="flex border border-border rounded-md">
                        <span class="p-2 text-red-500 transition hover:text-red-800 hover:animate-wiggle cursor-pointer">
                            <?= get_icon("trash-simple", IconSize::Large) ?>
                        </span>
                    </button>
                </div>
            </form>

            <div class="grow flex flex-col items-end">
                <?php if ($product->discount > 0) { ?>
                    <div class="flex flex-row items-center gap-x-1">
                        <span class="text-body-s px-2 bg-red-500 text-white rounded-full self-start">
                            ٪<?= $product->discount ?>
                        </span>
                        <span class="text-detail text-fg-2 line-through text-left">
                            <?= format_price($product->regular_price) ?> تومانء
                        </span>
                    </div>
                <?php } ?>
                <span class="text-body-s text-left">
                    <?= format_price($product->sale_price) ?> تومانء
                </span>
            </div>
        </div>
    </div>
</div>