<?php

use Services\dtos\ProductDto;

/* @var ProductDto $product */
$product = $args['product'];
?>

<div class="flex flex-col w-full h-full items-center gap-y-4 p-4 bg-white rounded-sm overflow-hidden">
    <a class="w-(--product-lg-width) h-(--product-lg-height) rounded-xl overflow-hidden" href="<?= $product->link ?>">
        <?= product_image($product->image) ?>
    </a>
    <a class="w-full flex flex-col" href="<?= $product->link ?>">
    <span class="text-detail w-full truncate">
                            <?= $product->category ?>
                            </span>
        <span class="text-body-s w-full line-clamp-2 text-justify
                        min-h-[calc(var(--text-body-s)*var(--text-body-s--line-height)*2)]">
                            <?= $product->title ?>
                            </span>
    </a>
    <div class="flex-1 flex flex-row items-end gap-x-1 w-full place-content-between">
        <form class="group/add-cart relative" data-type="add-to-cart" data-loading="false">
            <span class="data-[active='false']:hidden absolute w-5 h-5 text-detail bg-primary text-primary-fg-1 text-center content-center leading-0 -top-1 -right-1 rounded-full"
                  data-type="cart-quantity" data-product-id="<?= $product->id; ?>" data-active="false">
            </span>
            <input type="hidden" name="product_id" value="<?= $product->id; ?>">
            <input type="hidden" name="quantity" value="1">
            <button class="rounded-sm p-2 border border-border text-body transition hover:bg-neutral-100 cursor-pointer">
                <span class="group-data-[loading=false]/add-cart:hidden animate-spin flex">
                    <?= get_icon("spinner-gap") ?>
                </span>
                <span class="group-data-[loading=true]/add-cart:hidden">
                    <?= get_icon("plus") ?>
                </span>
            </button>
        </form>
        <div class="flex flex-col self-center items-end">
            <?php if ($product->discount > 0) { ?>
                <div class="flex flex-row items-center gap-x-1">
                                        <span class="text-detail px-2 bg-red-500 text-white rounded-full self-start leading-5">
                                            ٪<?= $product->discount ?>
                                        </span>
                    <span class="text-detail text-fg-2 line-through text-left">
                                            <?= format_price($product->regular_price) ?> تومانء
                                        </span>
                </div>
            <?php } ?>
            <span class="text-body-s text-left">
                                        <?= format_price($product->sale_price) ?> تومانء
                                    </span>
        </div>
    </div>
</div>