<?php

/* @var array{products: ProductDto, title: string, title_link: string, icon_name: string, icon_src: string} $args */

use Services\dtos\ProductDto;

/* @var array{products: ProductDto[]} $args */
$products = $args['products'];
$title = $args['title'];
$title_link = $args['title_link'] ?? '';
$icon_name = $args['icon_name'] ?? '';
$icon_src = $args['icon_src'] ?? '';
$size = $args['size'] ?? 'product';

$icon = empty($icon_name) ? null : get_icon($icon_name, IconSize::Large);
$icon = empty($icon_src) ? $icon : get_icon_image($icon_src, IconSize::Large);

?>

<div class="p-1 bg-primary-light rounded-3xl relative z-10" data-type="swiper" data-size="<?= $size ?>">
    <div class="flex flex-row text-h3 px-4 py-3">
        <?php if (!empty($title_link)) { ?>
            <a class="flex-1 flex flex-row items-center gap-x-4" href="<?= $title_link ?>">
                <span class="text-primary"><?= $icon ?></span>
                <span class="text-fg"> <?= $title ?> </span>
            </a>
        <?php } else { ?>
            <div class="flex-1 flex flex-row items-center gap-x-4">
                <span class="text-primary"><?= $icon ?></span>
                <span class="text-fg"> <?= $title ?> </span>
            </div>
        <?php } ?>
        <div class="flex flex-row-reverse gap-x-1">
            <button class="p-1 cursor-pointer transition-colors text-primary hover:text-primary-dark aria-[disabled=true]:text-neutral-400"
                    data-type="swiper-next">
                <?= get_icon("caret-left-fill") ?>
            </button>
            <button class="p-1 cursor-pointer transition-colors text-primary hover:text-primary-dark aria-[disabled=true]:text-neutral-400"
                    data-type="swiper-prev">
                <?= get_icon("caret-right-fill") ?>
            </button>
        </div>
    </div>
    <div class="swiper rounded-2xl">
        <div class="swiper-wrapper">
            <?php foreach ($products as $product) { ?>
                <div class="swiper-slide overflow-hidden first:rounded-s-2xl last:rounded-e-2xl">
                    <?php get_template_part("parts/product-card/product-card", null, ['product' => $product]); ?>
                </div>
            <?php } ?>
        </div>
    </div>
</div>