<?php

use services\dtos\SocialLinkDto;
use Services\enums\SocialLinkType;

/* @var array{social: SocialLinkDto} $args */
$social = $args['social'];

$type = $social->type;
?>

<a class="flex flex-col p-1 rounded-3xl gap-y-1" style="background: <?= $type->get_color(true) ?>"
   href="<?= esc_url($social->link) ?>">
    <div class="flex flex-row gap-x-4 bg-white rounded-2xl shadow-sm p-4 items-center text-body-s">
                            <span style="color: <?= $type->get_color() ?>">
                                <?= get_icon($type->get_logo_name(), IconSize::Large) ?>
                            </span>

        <?php if ($type == SocialLinkType::Instagram) { ?>
            <span class="grow">اینستاگرام
                                    <span style="color: <?= $type->get_color() ?>"><?= get_bloginfo() ?></span>
                                    را دنبال کنید.
                                </span>
        <?php } else if ($type == SocialLinkType::Telegram) { ?>
            <span class="grow">تلگرام
                                    <span style="color: <?= $type->get_color() ?>"><?= get_bloginfo() ?></span>
                                    را دنبال کنید.
                                </span>
        <?php } else { ?>
            <span class="grow">تمام مستقیم با
                                    <span style="color: <?= $type->get_color() ?>"><?= get_bloginfo() ?></span>.
                                </span>
        <?php } ?>

        <span class="text-body" style="color: <?= $type->get_color() ?>">
                                <?= get_icon("arrow-up-left") ?>
                            </span>
    </div>

    <span class="text-detail p-1 self-center" style="color: <?= $type->get_color() ?>">
                            <?= esc_url(urldecode($social->link)) ?>
                        </span>
</a>